/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.tlink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.feature.extractor.CleartkExtractor;
import org.cleartk.classifier.feature.extractor.simple.CoveredTextExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.classifier.feature.extractor.simple.TypePathExtractor;
import org.cleartk.classifier.opennlp.MaxentStringOutcomeDataWriter;
import org.cleartk.syntax.constituent.type.TreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNodeUtil;
import org.cleartk.timeml.tlink.TemporalLinkAnnotator_ImplBase;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.cleartk.timeml.util.SyntacticFirstChildOfGrandparentOfLeafExtractor;
import org.cleartk.timeml.util.SyntacticLeafToLeafPathPartsExtractor;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.util.JCasUtil;

public class TemporalLinkEventToSubordinatedEventAnnotator
extends TemporalLinkAnnotator_ImplBase<Event, Event> {
    public static final CleartkInternalModelFactory FACTORY = new CleartkInternalModelFactory(){

        @Override
        public Class<?> getAnnotatorClass() {
            return TemporalLinkEventToSubordinatedEventAnnotator.class;
        }

        @Override
        public Class<?> getDataWriterClass() {
            return MaxentStringOutcomeDataWriter.class;
        }

        @Override
        public AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createPrimitiveDescription(TemporalLinkEventToSubordinatedEventAnnotator.class, (Object[])new Object[0]);
        }
    };
    private static final Pattern SUBORDINATE_PATH_PATTERN = Pattern.compile("^(VP>|ADJP>|NP>)?(VP|ADJP|S|SBAR)(<(S|SBAR|PP))*((<VP|<ADJP)*|(<NP)*)$");

    public TemporalLinkEventToSubordinatedEventAnnotator() {
        super(Event.class, Event.class, "BEFORE", "OVERLAP", "AFTER");
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        List<SimpleFeatureExtractor> extractors = Arrays.asList(new TypePathExtractor(Event.class, "tense"), new TypePathExtractor(Event.class, "aspect"), new TypePathExtractor(Event.class, "eventClass"), new SyntacticFirstChildOfGrandparentOfLeafExtractor());
        this.setSourceExtractors(extractors);
        this.setTargetExtractors(extractors);
        this.setBetweenExtractors(Arrays.asList(new SyntacticLeafToLeafPathPartsExtractor(), new CleartkExtractor(Token.class, (SimpleFeatureExtractor)new CoveredTextExtractor(), new CleartkExtractor.Context[]{new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()})})));
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        Map links = this.getLinks(jCas);
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            for (Event source : JCasUtil.selectCovered((JCas)jCas, Event.class, (AnnotationFS)sentence)) {
                for (Event target : this.getSubordinateEvents(jCas, source, sentence)) {
                    this.processLink(source, target, links, jCas);
                }
            }
        }
        this.logSkippedLinks(jCas, links);
    }

    private List<Event> getSubordinateEvents(JCas jCas, Event source, Sentence sentence) {
        ArrayList<Event> targets = new ArrayList<Event>();
        TreebankNode sourceNode = TreebankNodeUtil.selectMatchingLeaf((JCas)jCas, (Annotation)source);
        for (Event target : JCasUtil.selectCovered((JCas)jCas, Event.class, (AnnotationFS)sentence)) {
            String path;
            TreebankNode targetNode = TreebankNodeUtil.selectMatchingLeaf((JCas)jCas, (Annotation)target);
            if (sourceNode == null || targetNode == null || !SUBORDINATE_PATH_PATTERN.matcher(path = TemporalLinkEventToSubordinatedEventAnnotator.noLeavesPath(TreebankNodeUtil.getPath((TreebankNode)sourceNode, (TreebankNode)targetNode))).matches()) continue;
            targets.add(target);
        }
        return targets;
    }
}

