/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.tlink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.cleartk.classifier.CleartkAnnotator;
import org.cleartk.classifier.Instance;
import org.cleartk.classifier.feature.extractor.CleartkExtractor;
import org.cleartk.classifier.feature.extractor.simple.CoveredTextExtractor;
import org.cleartk.classifier.feature.extractor.simple.NamingExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.classifier.feature.extractor.simple.TypePathExtractor;
import org.cleartk.classifier.opennlp.MaxentStringOutcomeDataWriter;
import org.cleartk.syntax.constituent.type.TopTreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNode;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.type.TemporalLink;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.cleartk.timeml.util.TargetPathExtractor;
import org.cleartk.timeml.util.TokenTextForSelectedPOSExtractor;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.cleartk.util.AnnotationUtil;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.descriptor.TypeCapability;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.uimafit.util.JCasUtil;

@TypeCapability(outputs={"org.cleartk.timeml.type.TemporalLink", "org.cleartk.timeml.type.Event"})
public class VerbClauseTemporalAnnotator
extends CleartkAnnotator<String> {
    public static final CleartkInternalModelFactory FACTORY = new CleartkInternalModelFactory(){

        @Override
        public Class<?> getAnnotatorClass() {
            return VerbClauseTemporalAnnotator.class;
        }

        @Override
        public Class<?> getDataWriterClass() {
            return MaxentStringOutcomeDataWriter.class;
        }

        @Override
        public AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createPrimitiveDescription(VerbClauseTemporalAnnotator.class, (Object[])new Object[0]);
        }
    };
    private static final Map<String, String[]> headMap = new HashMap<String, String[]>();
    private static final Set<String> stopWords;
    private List<SimpleFeatureExtractor> sourceFeatureExtractors;
    private List<SimpleFeatureExtractor> targetFeatureExtractors;
    private List<SimpleFeatureExtractor> betweenAnchorsFeatureExtractors;
    private TargetPathExtractor pathExtractor;
    private int eventID = 1;
    @ConfigurationParameter(defaultValue={"false"}, description="Create events for all verbs in verb-clause relations (using existing events if present, but adding new ones wherever they are not present).")
    private boolean createEvents;
    public static final String PARAM_CREATE_EVENTS;

    public VerbClauseTemporalAnnotator() {
        CleartkExtractor precedingAuxiliaries = new CleartkExtractor(Token.class, (SimpleFeatureExtractor)new TokenTextForSelectedPOSExtractor("MD", "TO", "IN", "VB", "RB"), new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(3)});
        TypePathExtractor tokenStemExtractor = new TypePathExtractor(Token.class, "stem");
        TypePathExtractor tokenPOSExtractor = new TypePathExtractor(Token.class, "pos");
        this.sourceFeatureExtractors = new ArrayList<SimpleFeatureExtractor>();
        this.sourceFeatureExtractors.add((SimpleFeatureExtractor)new NamingExtractor("Source", (SimpleFeatureExtractor)new CoveredTextExtractor()));
        this.sourceFeatureExtractors.add((SimpleFeatureExtractor)new NamingExtractor("Source", (SimpleFeatureExtractor)tokenPOSExtractor));
        this.sourceFeatureExtractors.add((SimpleFeatureExtractor)new NamingExtractor("Source", (SimpleFeatureExtractor)tokenStemExtractor));
        this.sourceFeatureExtractors.add((SimpleFeatureExtractor)new NamingExtractor("Source", (SimpleFeatureExtractor)precedingAuxiliaries));
        this.targetFeatureExtractors = new ArrayList<SimpleFeatureExtractor>();
        this.targetFeatureExtractors.add((SimpleFeatureExtractor)new NamingExtractor("Target", (SimpleFeatureExtractor)new CoveredTextExtractor()));
        this.targetFeatureExtractors.add((SimpleFeatureExtractor)new NamingExtractor("Target", (SimpleFeatureExtractor)tokenPOSExtractor));
        this.targetFeatureExtractors.add((SimpleFeatureExtractor)new NamingExtractor("Target", (SimpleFeatureExtractor)tokenStemExtractor));
        this.targetFeatureExtractors.add((SimpleFeatureExtractor)new NamingExtractor("Target", (SimpleFeatureExtractor)precedingAuxiliaries));
        this.betweenAnchorsFeatureExtractors = new ArrayList<SimpleFeatureExtractor>();
        this.betweenAnchorsFeatureExtractors.add((SimpleFeatureExtractor)new NamingExtractor("WordsBetween", (SimpleFeatureExtractor)new CleartkExtractor(Token.class, (SimpleFeatureExtractor)new CoveredTextExtractor(), new CleartkExtractor.Context[]{new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()})})));
        this.pathExtractor = new TargetPathExtractor();
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        int docEnd = jCas.getDocumentText().length();
        Map<String, TemporalLink> tlinks = null;
        if (this.isTraining()) {
            tlinks = this.getTemporalLinks(jCas);
        }
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            TopTreebankNode tree = (TopTreebankNode)AnnotationUtil.selectFirstMatching((JCas)jCas, TopTreebankNode.class, (Annotation)sentence);
            if (tree == null) {
                String fmt = "missing syntactic parse for sentence: %s";
                String msg = String.format(fmt, sentence.getCoveredText());
                this.getContext().getLogger().log(Level.WARNING, msg);
                continue;
            }
            ArrayList<TreebankNodeLink> links = new ArrayList<TreebankNodeLink>();
            this.collectVerbClausePairs((TreebankNode)tree, links);
            for (TreebankNodeLink link : links) {
                TemporalLink tlink;
                Token sourceToken = (Token)JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)link.source).get(0);
                Token targetToken = (Token)JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)link.target).get(0);
                int firstEnd = Math.min(sourceToken.getEnd(), targetToken.getEnd());
                int lastBegin = Math.max(sourceToken.getBegin(), targetToken.getBegin());
                Instance instance = new Instance();
                for (SimpleFeatureExtractor extractor : this.sourceFeatureExtractors) {
                    instance.addAll((Collection)extractor.extract(jCas, (Annotation)sourceToken));
                }
                for (SimpleFeatureExtractor extractor : this.targetFeatureExtractors) {
                    instance.addAll((Collection)extractor.extract(jCas, (Annotation)targetToken));
                }
                Annotation windowAnnotation = new Annotation(jCas, firstEnd, lastBegin);
                for (SimpleFeatureExtractor extractor : this.betweenAnchorsFeatureExtractors) {
                    instance.addAll((Collection)extractor.extract(jCas, windowAnnotation));
                }
                instance.addAll(this.pathExtractor.extract(jCas, link.source, link.target));
                Anchor source = (Anchor)AnnotationUtil.selectFirstMatching((JCas)jCas, Anchor.class, (Annotation)link.source);
                Anchor target = (Anchor)AnnotationUtil.selectFirstMatching((JCas)jCas, Anchor.class, (Annotation)link.target);
                if (this.isTraining()) {
                    String key;
                    if (source == null || target == null || (tlink = tlinks.remove(key = String.format("%s:%s", source.getId(), target.getId()))) == null) continue;
                    instance.setOutcome((Object)tlink.getRelationType());
                    this.dataWriter.write(instance);
                    continue;
                }
                source = this.getOrCreateEvent(jCas, source, link.source);
                target = this.getOrCreateEvent(jCas, target, link.target);
                if (source == null || target == null) continue;
                String relationType = (String)this.classifier.classify(instance.getFeatures());
                tlink = new TemporalLink(jCas, docEnd, docEnd);
                tlink.setSource(source);
                tlink.setTarget(target);
                tlink.setRelationType(relationType);
                tlink.addToIndexes();
            }
        }
    }

    private Event getOrCreateEvent(JCas jCas, Anchor anchor, TreebankNode node) {
        if (anchor != null && anchor instanceof Event) {
            return (Event)anchor;
        }
        if (this.createEvents) {
            Event event = new Event(jCas, node.getBegin(), node.getEnd());
            event.setId("e" + this.eventID);
            ++this.eventID;
            event.addToIndexes();
            return event;
        }
        return null;
    }

    private Map<String, TemporalLink> getTemporalLinks(JCas jCas) {
        HashMap<String, TemporalLink> tlinks = new HashMap<String, TemporalLink>();
        for (TemporalLink tlink : JCasUtil.select((JCas)jCas, TemporalLink.class)) {
            String sourceID = tlink.getSource().getId();
            String targetID = tlink.getTarget().getId();
            String key = String.format("%s:%s", sourceID, targetID);
            tlinks.put(key, tlink);
        }
        return tlinks;
    }

    private void collectVerbClausePairs(TreebankNode node, List<TreebankNodeLink> links) {
        if (this.isVerbPhrase(node)) {
            ArrayList<TreebankNode> sources = new ArrayList<TreebankNode>();
            ArrayList<TreebankNode> targets = new ArrayList<TreebankNode>();
            this.collectHeads(node, sources);
            for (int i = 0; i < node.getChildren().size(); ++i) {
                TreebankNode child = node.getChildren(i);
                if (!this.isClause(child)) continue;
                targets.clear();
                this.collectHeads(child, targets);
                for (TreebankNode source : sources) {
                    for (TreebankNode target : targets) {
                        if (this.contains(child, source)) continue;
                        links.add(new TreebankNodeLink(source, target));
                    }
                }
            }
        }
        for (int i = 0; i < node.getChildren().size(); ++i) {
            TreebankNode child = node.getChildren(i);
            this.collectVerbClausePairs(child, links);
        }
    }

    private void collectHeads(TreebankNode node, List<TreebankNode> heads) {
        String[] headTypes;
        if (node.getLeaf()) {
            heads.add(node);
        }
        if ((headTypes = headMap.get(node.getNodeType())) != null) {
            for (String headType : headTypes) {
                boolean foundChildWithHeadType = false;
                for (int i = 0; i < node.getChildren().size(); ++i) {
                    String text;
                    TreebankNode child = node.getChildren(i);
                    if (!child.getNodeType().equals(headType) || stopWords.contains(text = child.getCoveredText())) continue;
                    this.collectHeads(child, heads);
                    foundChildWithHeadType = true;
                }
                if (foundChildWithHeadType) break;
            }
        }
    }

    private boolean contains(TreebankNode node, TreebankNode descendant) {
        if (node == descendant) {
            return true;
        }
        for (int i = 0; i < node.getChildren().size(); ++i) {
            boolean result = this.contains(node.getChildren(i), descendant);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private boolean isVerbPhrase(TreebankNode node) {
        return node.getNodeType().startsWith("VP");
    }

    private boolean isClause(TreebankNode node) {
        return node.getNodeType().startsWith("S");
    }

    static {
        headMap.put("S", "VP S SBAR ADJP".split(" "));
        headMap.put("SBAR", "VP S SBAR ADJP".split(" "));
        headMap.put("VP", "VP VB VBZ VBP VBG VBN VBD JJ JJR JJS NNS NN PRP NNPS NNP ADJP NP S SBAR".split(" "));
        headMap.put("ADJP", "ADJP VB VBZ VBP VBG VBN VBD JJ JJR JJS".split(" "));
        headMap.put("NP", "NP NNS NN PRP NNPS NNP QP ADJP".split(" "));
        headMap.put("QP", "NP NNS NN PRP NNPS NNP QP ADJP".split(" "));
        stopWords = new HashSet<String>(Arrays.asList("be been is 's am are was were has had have".split(" ")));
        PARAM_CREATE_EVENTS = ConfigurationParameterFactory.createConfigurationParameterName(VerbClauseTemporalAnnotator.class, (String)"createEvents");
    }

    private class TreebankNodeLink {
        public TreebankNode source;
        public TreebankNode target;

        public TreebankNodeLink(TreebankNode source, TreebankNode target) {
            this.source = source;
            this.target = target;
        }
    }
}

