/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.uima.jcas.JCas;
import org.cleartk.classifier.Feature;
import org.cleartk.syntax.constituent.type.TreebankNode;

public class TargetPathExtractor {
    public List<Feature> extract(JCas jCas, TreebankNode source, TreebankNode target) {
        List<TreebankNode> sourceToRoot = this.pathToRoot(source);
        List<TreebankNode> targetToRoot = this.pathToRoot(target);
        while (!sourceToRoot.isEmpty() && !targetToRoot.isEmpty() && sourceToRoot.get(sourceToRoot.size() - 1) == targetToRoot.get(targetToRoot.size() - 1)) {
            sourceToRoot.remove(sourceToRoot.size() - 1);
            targetToRoot.remove(targetToRoot.size() - 1);
        }
        String value = this.toTagString(targetToRoot, ">");
        return Collections.singletonList(new Feature("TargetPath", (Object)value));
    }

    private List<TreebankNode> pathToRoot(TreebankNode leaf) {
        ArrayList<TreebankNode> result = new ArrayList<TreebankNode>();
        for (TreebankNode curr = leaf; curr != null; curr = curr.getParent()) {
            result.add(curr);
        }
        return result;
    }

    private String toTagString(List<TreebankNode> nodes, String join) {
        StringBuilder builder = new StringBuilder();
        for (TreebankNode node : nodes) {
            if (builder.length() > 0) {
                builder.append(join);
            }
            builder.append(node.getNodeType());
        }
        return builder.toString();
    }
}

