/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.DocumentCreationTime;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.type.TemporalLink;
import org.cleartk.timeml.type.Time;
import org.jdom2.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class TimeMLUtil {
    private static final Map<String, String> elementNames = new HashMap<String, String>();
    private static final List<NamePair> eventAttributes = new ArrayList<NamePair>();
    private static final List<NamePair> timeAttributes = new ArrayList<NamePair>();
    private static final List<NamePair> tlinkAttributes = new ArrayList<NamePair>();
    private static final Map<String, List<NamePair>> timemlAttributeLists = new HashMap<String, List<NamePair>>();
    private static final Map<Class<?>, List<NamePair>> uimaAttributeLists = new HashMap();

    public static void copyAttributes(Element element, Annotation annotation, JCas jCas) {
        for (NamePair names : timemlAttributeLists.get(element.getName())) {
            String featureValue = element.getAttributeValue(names.timemlName);
            if (featureValue == null) continue;
            String className = annotation.getClass().getName();
            String uimaName = String.format("%s:%s", className, names.uimaName);
            Feature feature = jCas.getTypeSystem().getFeatureByFullName(uimaName);
            annotation.setFeatureValueFromString(feature, featureValue);
        }
    }

    public static void removeInconsistentAttributes(Element element, Annotation annotation, JCas jCas) {
        for (NamePair names : timemlAttributeLists.get(element.getName())) {
            String newValue = element.getAttributeValue(names.timemlName);
            String className = annotation.getClass().getName();
            String uimaName = String.format("%s:%s", className, names.uimaName);
            Feature feature = jCas.getTypeSystem().getFeatureByFullName(uimaName);
            String oldValue = annotation.getFeatureValueAsString(feature);
            if (oldValue == null || oldValue.equals(newValue)) continue;
            annotation.setFeatureValueFromString(feature, null);
        }
    }

    public static String toTimeMLElementName(AnnotationFS annotation) {
        if (annotation instanceof Event) {
            return "EVENT";
        }
        if (annotation instanceof Time) {
            return "TIMEX3";
        }
        if (annotation instanceof TemporalLink) {
            return "TLINK";
        }
        return null;
    }

    public static Attributes toTimeMLAttributes(AnnotationFS annotation, String elementName) {
        AttributesImpl attributes = new AttributesImpl();
        for (NamePair names : timemlAttributeLists.get(elementName)) {
            Feature feature = annotation.getType().getFeatureByBaseName(names.uimaName);
            TimeMLUtil.addAttribute(attributes, names.timemlName, annotation.getFeatureValueAsString(feature));
        }
        if (annotation instanceof TemporalLink) {
            Event event;
            TemporalLink tlink = (TemporalLink)annotation;
            Anchor source = tlink.getSource();
            Anchor target = tlink.getTarget();
            if (source instanceof Event) {
                event = (Event)source;
                TimeMLUtil.addAttribute(attributes, "eventID", event.getId());
                TimeMLUtil.addAttribute(attributes, "eventInstanceID", event.getEventInstanceID());
            } else if (source instanceof Time) {
                TimeMLUtil.addAttribute(attributes, "timeID", source.getId());
            }
            if (target instanceof Event) {
                event = (Event)target;
                TimeMLUtil.addAttribute(attributes, "relatedToEvent", event.getId());
                TimeMLUtil.addAttribute(attributes, "relatedToEventInstance", event.getEventInstanceID());
            } else if (target instanceof Time) {
                TimeMLUtil.addAttribute(attributes, "relatedToTime", target.getId());
            }
        }
        return attributes;
    }

    private static void addAttribute(AttributesImpl attributes, String name, String value) {
        if (value != null) {
            attributes.addAttribute("", name, name, "CDATA", value);
        }
    }

    static {
        elementNames.put("Document", "TimeML");
        elementNames.put(Event.class.getName(), "EVENT");
        elementNames.put(Time.class.getName(), "TIMEX3");
        elementNames.put(DocumentCreationTime.class.getName(), "TIMEX3");
        elementNames.put(TemporalLink.class.getName(), "TLINK");
        eventAttributes.add(new NamePair("eid", "id"));
        eventAttributes.add(new NamePair("eiid", "eventInstanceID"));
        eventAttributes.add(new NamePair("class", "eventClass"));
        for (String name : new String[]{"stem", "pos", "tense", "aspect", "cardinality", "polarity", "modality", "signalID"}) {
            eventAttributes.add(new NamePair(name, name));
        }
        timeAttributes.add(new NamePair("tid", "id"));
        timeAttributes.add(new NamePair("type", "timeType"));
        for (String name : new String[]{"beginPoint", "endPoint", "quant", "freq", "functionInDocument", "temporalFunction", "value", "valueFromFunction", "mod"}) {
            timeAttributes.add(new NamePair(name, name));
        }
        tlinkAttributes.add(new NamePair("lid", "id"));
        tlinkAttributes.add(new NamePair("relType", "relationType"));
        tlinkAttributes.add(new NamePair("signalID", "signalID"));
        timemlAttributeLists.put("EVENT", eventAttributes);
        timemlAttributeLists.put("MAKEINSTANCE", eventAttributes);
        timemlAttributeLists.put("TIMEX3", timeAttributes);
        timemlAttributeLists.put("TLINK", tlinkAttributes);
        uimaAttributeLists.put(Event.class, eventAttributes);
        uimaAttributeLists.put(Time.class, timeAttributes);
        uimaAttributeLists.put(TemporalLink.class, tlinkAttributes);
    }

    private static class NamePair {
        public String timemlName;
        public String uimaName;

        public NamePair(String timemlName, String uimaName) {
            this.timemlName = timemlName;
            this.uimaName = uimaName;
        }
    }
}

