/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.feature.extractor.CleartkExtractorException;
import org.cleartk.classifier.feature.extractor.simple.CoveredTextExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.token.type.Token;

public class TokenTextForSelectedPOSExtractor
implements SimpleFeatureExtractor {
    private Set<String> acceptablePOSTags;
    private SimpleFeatureExtractor extractor;

    public TokenTextForSelectedPOSExtractor(Collection<String> acceptablePOSTags) {
        this.acceptablePOSTags = new HashSet<String>(acceptablePOSTags);
        this.extractor = new CoveredTextExtractor();
    }

    public TokenTextForSelectedPOSExtractor(String ... acceptablePOSTags) {
        this(Arrays.asList(acceptablePOSTags));
    }

    public List<Feature> extract(JCas view, Annotation focusAnnotation) throws CleartkExtractorException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        Token token = (Token)focusAnnotation;
        String pos = token.getPos();
        if (pos != null) {
            if (pos.length() > 2) {
                pos = pos.substring(0, 2);
            }
            if (this.acceptablePOSTags.contains(pos)) {
                features.addAll(this.extractor.extract(view, (Annotation)token));
            }
        }
        return features;
    }
}

