/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.corpus;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.XMLSerializer;
import org.cleartk.timeml.util.TimeMLUtil;
import org.cleartk.util.ViewURIUtil;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@Deprecated
public class TempEval2007Writer
extends JCasAnnotator_ImplBase {
    public static final String PARAM_OUTPUT_DIRECTORY_NAME = ConfigurationParameterFactory.createConfigurationParameterName(TempEval2007Writer.class, (String)"outputDirectoryName");
    @ConfigurationParameter(description="Provides the path where the TimeML documents should be written.", mandatory=true)
    private String outputDirectoryName;
    private File outputDirectory;

    public static AnalysisEngineDescription getDescription(String outputDir) throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(TempEval2007Writer.class, (Object[])new Object[]{PARAM_OUTPUT_DIRECTORY_NAME, outputDir});
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.outputDirectory = new File(this.outputDirectoryName);
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
    }

    public static String toTimeML(JCas jCas) throws AnalysisEngineProcessException {
        try {
            return TempEval2007Writer.toXML(jCas.getCas(), new TimeMLAnnotationsToElements());
        }
        catch (SAXException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String xmlString = TempEval2007Writer.toTimeML(jCas);
        String filePath = ViewURIUtil.getURI((JCas)jCas).getPath();
        String fileName = new File(filePath).getName();
        if (!fileName.endsWith(".tml")) {
            fileName = fileName + ".tml";
        }
        File outputFile = new File(this.outputDirectory, fileName);
        try {
            FileWriter writer = new FileWriter(outputFile);
            writer.write(xmlString);
            writer.close();
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public void setOutputDirectoryName(String outputDirectoryName) {
        this.outputDirectoryName = outputDirectoryName;
    }

    private static String toXML(CAS cas, AnnotationsToElements converter) throws SAXException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLSerializer sax2xml = new XMLSerializer((OutputStream)byteArrayOutputStream, false);
        String docText = cas.getDocumentText();
        char[] docCharArray = docText.toCharArray();
        FSIterator iterator = cas.getAnnotationIndex().iterator();
        ArrayList<AnnotationFS> stack = new ArrayList<AnnotationFS>();
        int pos = 0;
        ContentHandler handler = sax2xml.getContentHandler();
        handler.startDocument();
        converter.startRootElement(handler);
        AnnotationFS curAnnot = null;
        while (iterator.isValid()) {
            AnnotationFS nextAnnot = (AnnotationFS)iterator.get();
            if (curAnnot == null || nextAnnot.getBegin() < curAnnot.getEnd()) {
                if (curAnnot == null || nextAnnot.getEnd() <= curAnnot.getEnd()) {
                    try {
                        handler.characters(docCharArray, pos, nextAnnot.getBegin() - pos);
                        pos = nextAnnot.getBegin();
                        converter.startAnnotationElement(nextAnnot, handler);
                        stack.add(curAnnot);
                        curAnnot = nextAnnot;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        System.err.println("Invalid annotation range: " + nextAnnot.getBegin() + "," + nextAnnot.getEnd() + " in document of length " + docText.length());
                    }
                }
                iterator.moveToNext();
                continue;
            }
            try {
                handler.characters(docCharArray, pos, curAnnot.getEnd() - pos);
                pos = curAnnot.getEnd();
            }
            catch (StringIndexOutOfBoundsException e) {
                System.err.println("Invalid annotation range: " + curAnnot.getBegin() + "," + curAnnot.getEnd() + " in document of length " + docText.length());
            }
            converter.endAnnotationElement(curAnnot, handler);
            curAnnot = (AnnotationFS)stack.remove(stack.size() - 1);
        }
        if (curAnnot != null) {
            try {
                handler.characters(docCharArray, pos, curAnnot.getEnd() - pos);
                pos = curAnnot.getEnd();
            }
            catch (StringIndexOutOfBoundsException e) {
                System.err.println("Invalid annotation range: " + curAnnot.getBegin() + "," + curAnnot.getEnd() + "in document of length " + docText.length());
            }
            converter.endAnnotationElement(curAnnot, handler);
            while (!stack.isEmpty() && (curAnnot = (AnnotationFS)stack.remove(stack.size() - 1)) != null) {
                try {
                    handler.characters(docCharArray, pos, curAnnot.getEnd() - pos);
                    pos = curAnnot.getEnd();
                }
                catch (StringIndexOutOfBoundsException e) {
                    System.err.println("Invalid annotation range: " + curAnnot.getBegin() + "," + curAnnot.getEnd() + "in document of length " + docText.length());
                }
                converter.endAnnotationElement(curAnnot, handler);
            }
        }
        if (pos < docCharArray.length) {
            handler.characters(docCharArray, pos, docCharArray.length - pos);
        }
        converter.endRootElement(handler);
        handler.endDocument();
        return new String(byteArrayOutputStream.toByteArray());
    }

    private static class TimeMLAnnotationsToElements
    implements AnnotationsToElements {
        @Override
        public void startRootElement(ContentHandler handler) throws SAXException {
            handler.startElement("", "TimeML", "TimeML", new AttributesImpl());
        }

        @Override
        public void endRootElement(ContentHandler handler) throws SAXException {
            handler.endElement("", "TimeML", "TimeML");
        }

        @Override
        public void startAnnotationElement(AnnotationFS annotation, ContentHandler handler) throws SAXException {
            String name = TimeMLUtil.toTimeMLElementName(annotation);
            if (name != null) {
                handler.startElement("", name, name, TimeMLUtil.toTempEval2007Attributes(annotation, name));
            }
        }

        @Override
        public void endAnnotationElement(AnnotationFS annotation, ContentHandler handler) throws SAXException {
            String name = TimeMLUtil.toTimeMLElementName(annotation);
            if (name != null) {
                handler.endElement("", name, name);
            }
        }
    }

    private static interface AnnotationsToElements {
        public void startRootElement(ContentHandler var1) throws SAXException;

        public void endRootElement(ContentHandler var1) throws SAXException;

        public void startAnnotationElement(AnnotationFS var1, ContentHandler var2) throws SAXException;

        public void endAnnotationElement(AnnotationFS var1, ContentHandler var2) throws SAXException;
    }
}

