/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.corpus;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.jcas.tcas.DocumentAnnotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.DocumentCreationTime;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.type.TemporalLink;
import org.cleartk.timeml.type.Text;
import org.cleartk.timeml.type.Time;
import org.cleartk.util.ViewURIUtil;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;
import org.uimafit.component.JCasAnnotator_ImplBase;
import org.uimafit.descriptor.ConfigurationParameter;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.factory.ConfigurationParameterFactory;

@Deprecated
public class TempEval2013Writer
extends JCasAnnotator_ImplBase {
    public static final String PARAM_OUTPUT_DIRECTORY = ConfigurationParameterFactory.createConfigurationParameterName(TempEval2013Writer.class, (String)"outputDirectory");
    @ConfigurationParameter(description="Provides the path where the TimeML documents should be written.", mandatory=true)
    private File outputDirectory;

    public static AnalysisEngineDescription getDescription(File outputDir) throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(TempEval2013Writer.class, (Object[])new Object[]{PARAM_OUTPUT_DIRECTORY, outputDir});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String inputSuffix;
        String text = jCas.getDocumentText();
        Ordering spanOrdering = Span.BY_DECREASING_BEGIN.compound(Span.BY_INCREASING_END);
        List<AnnotationFS> annotations = this.getAnnotations(jCas);
        Collections.sort(annotations, spanOrdering.onResultOf((Function)new Function<AnnotationFS, Span>(){

            public Span apply(AnnotationFS annotation) {
                return new Span(annotation);
            }
        }));
        TreeMap spanToElements = new TreeMap((Comparator<Span>)spanOrdering);
        for (AnnotationFS annotation : annotations) {
            ArrayList<Span> coveredSpans = new ArrayList<Span>();
            if (annotation.getBegin() != annotation.getEnd()) {
                for (Span span : spanToElements.headMap(new Span(annotation), true).keySet()) {
                    if (annotation.getBegin() > span.begin || span.end > annotation.getEnd()) continue;
                    coveredSpans.add(span);
                }
            }
            ArrayList<Integer> boundaries = new ArrayList<Integer>();
            boundaries.add(annotation.getBegin());
            boundaries.add(annotation.getEnd());
            for (Span span : coveredSpans) {
                boundaries.add(span.begin);
                boundaries.add(span.end);
            }
            Collections.sort(boundaries);
            ArrayList<org.jdom2.Text> children = new ArrayList<org.jdom2.Text>();
            for (int i = 0; i < boundaries.size() - 1; ++i) {
                int begin = (Integer)boundaries.get(i);
                int end = (Integer)boundaries.get(i + 1);
                if (i % 2 == 0) {
                    children.add(new org.jdom2.Text(text.substring(begin, end)));
                    continue;
                }
                children.addAll((Collection)spanToElements.remove(new Span(begin, end)));
            }
            Element element = this.toElement(annotation);
            element.addContent(children);
            Span span = new Span(annotation);
            if (!spanToElements.containsKey(span)) {
                spanToElements.put(span, new ArrayList());
            }
            ((List)spanToElements.get(span)).add(element);
        }
        Span rootSpan = new Span(0, text.length());
        List rootElements = (List)spanToElements.get(rootSpan);
        if (rootElements == null || rootElements.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one root, found " + spanToElements);
        }
        Element root = (Element)rootElements.get(0);
        XMLOutputter outputter = new XMLOutputter();
        String fileName = new File(ViewURIUtil.getURI((JCas)jCas).getPath()).getName();
        if (fileName.endsWith(inputSuffix = ".TE3input")) {
            fileName = fileName.substring(0, fileName.length() - inputSuffix.length());
        }
        if (!fileName.endsWith(".tml")) {
            fileName = fileName + ".tml";
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        File outputFile = new File(this.outputDirectory, fileName);
        try {
            FileOutputStream outputStream = new FileOutputStream(outputFile);
            try {
                outputter.output(root, (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    protected List<AnnotationFS> getAnnotations(JCas jCas) {
        int makeInstanceOffset = jCas.getDocumentText().length();
        ArrayList<AnnotationFS> annotations = new ArrayList<AnnotationFS>();
        FSIterator iterator = jCas.getAnnotationIndex().iterator();
        while (iterator.isValid() && iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            if (!(annotation instanceof DocumentAnnotation) && !(annotation instanceof Text) && !(annotation instanceof Event) && !(annotation instanceof Time) && !(annotation instanceof TemporalLink)) continue;
            annotations.add((AnnotationFS)annotation);
            if (annotation instanceof DocumentCreationTime) {
                annotations.add(new DCT((Time)((DocumentCreationTime)annotation)));
            }
            if (!(annotation instanceof Event)) continue;
            annotations.add(new MakeInstance((Event)annotation, makeInstanceOffset));
        }
        return annotations;
    }

    protected Element toElement(AnnotationFS annotation) {
        Element element;
        if (annotation instanceof DocumentAnnotation) {
            element = new Element("TimeML");
        } else if (annotation instanceof DCT) {
            element = new Element("DCT");
        } else if (annotation instanceof Text) {
            element = new Element("TEXT");
        } else if (annotation instanceof Event) {
            Event event = (Event)annotation;
            element = new Element("EVENT");
            element.setAttribute("eid", event.getId());
            element.setAttribute("class", TempEval2013Writer.nullToEmpty(event.getEventClass()));
            element.setAttribute("tense", TempEval2013Writer.nullToEmpty(event.getTense()));
            element.setAttribute("aspect", TempEval2013Writer.nullToEmpty(event.getAspect()));
            element.setAttribute("polarity", TempEval2013Writer.nullToEmpty(event.getPolarity()));
            element.setAttribute("modality", TempEval2013Writer.nullToEmpty(event.getModality()));
        } else if (annotation instanceof MakeInstance) {
            MakeInstance makeInstance = (MakeInstance)annotation;
            element = new Element("MAKEINSTANCE");
            element.setAttribute("eiid", ((Event)makeInstance.annotation).getEventInstanceID());
            element.setAttribute("eventID", ((Event)makeInstance.annotation).getId());
        } else if (annotation instanceof Time) {
            Time time = (Time)annotation;
            element = new Element("TIMEX3");
            element.setAttribute("tid", time.getId());
            element.setAttribute("type", TempEval2013Writer.nullToEmpty(time.getTimeType()));
            element.setAttribute("value", TempEval2013Writer.nullToEmpty(time.getValue()));
        } else if (annotation instanceof TemporalLink) {
            Event event;
            TemporalLink tlink = (TemporalLink)annotation;
            Anchor source = tlink.getSource();
            Anchor target = tlink.getTarget();
            element = new Element("TLINK");
            element.setAttribute("lid", tlink.getId());
            element.setAttribute("relType", tlink.getRelationType());
            if (source instanceof Event) {
                event = (Event)source;
                element.setAttribute("eventInstanceID", event.getEventInstanceID());
            } else if (source instanceof Time) {
                element.setAttribute("timeID", source.getId());
            }
            if (target instanceof Event) {
                event = (Event)target;
                element.setAttribute("relatedToEventInstance", event.getEventInstanceID());
            } else if (target instanceof Time) {
                element.setAttribute("relatedToTime", target.getId());
            }
        } else {
            throw new IllegalArgumentException("Unsupported annotation type: " + annotation);
        }
        return element;
    }

    private static String nullToEmpty(String string) {
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static class FakeAnnotation<T extends Annotation>
    implements AnnotationFS {
        T annotation;
        private int begin;
        private int end;

        public FakeAnnotation(T annotation, int begin, int end) {
            this.annotation = annotation;
            this.begin = begin;
            this.end = end;
        }

        public Object clone() {
            throw new UnsupportedOperationException();
        }

        public CAS getView() {
            throw new UnsupportedOperationException();
        }

        public Type getType() {
            throw new UnsupportedOperationException();
        }

        public void setFeatureValue(Feature feat, FeatureStructure fs) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public FeatureStructure getFeatureValue(Feature feat) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public void setStringValue(Feature feat, String s) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public String getStringValue(Feature f) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public float getFloatValue(Feature feat) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public void setFloatValue(Feature feat, float f) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public int getIntValue(Feature feat) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public void setIntValue(Feature feat, int i) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public byte getByteValue(Feature feat) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public void setByteValue(Feature feat, byte i) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public boolean getBooleanValue(Feature feat) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public void setBooleanValue(Feature feat, boolean i) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public short getShortValue(Feature feat) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public void setShortValue(Feature feat, short i) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public long getLongValue(Feature feat) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public void setLongValue(Feature feat, long i) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public double getDoubleValue(Feature feat) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public void setDoubleValue(Feature feat, double i) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public String getFeatureValueAsString(Feature feat) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public void setFeatureValueFromString(Feature feat, String s) throws CASRuntimeException {
            throw new UnsupportedOperationException();
        }

        public CAS getCAS() {
            throw new UnsupportedOperationException();
        }

        public int getBegin() {
            return this.begin;
        }

        public int getEnd() {
            return this.end;
        }

        public String getCoveredText() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DCT
    extends FakeAnnotation<Time> {
        public DCT(Time time) {
            super(time, time.getBegin(), time.getEnd());
        }
    }

    private static class MakeInstance
    extends FakeAnnotation<Event> {
        public MakeInstance(Event annotation, int offset) {
            super(annotation, offset, offset);
        }
    }

    private static class Span
    implements Comparable<Span> {
        int begin;
        int end;
        static Ordering<Span> BY_DECREASING_BEGIN = new Ordering<Span>(){

            public int compare(Span left, Span right) {
                return -Ints.compare((int)left.begin, (int)right.begin);
            }
        };
        static Ordering<Span> BY_INCREASING_END = new Ordering<Span>(){

            public int compare(Span left, Span right) {
                return Ints.compare((int)left.end, (int)right.end);
            }
        };

        public Span(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public Span(AnnotationFS annotation) {
            this(annotation.getBegin(), annotation.getEnd());
        }

        public String toString() {
            Objects.ToStringHelper helper = Objects.toStringHelper(this.getClass());
            return helper.add("begin", this.begin).add("end", this.end).toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.begin, this.end});
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj.getClass().equals(Span.class)) {
                Span that = (Span)obj;
                result = this.begin == that.begin && this.end == that.end;
            }
            return result;
        }

        @Override
        public int compareTo(Span that) {
            int compare = Ints.compare((int)this.begin, (int)that.begin);
            if (compare != 0) {
                compare = Ints.compare((int)this.end, (int)that.end);
            }
            return compare;
        }
    }
}

