/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.eval;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.Feature;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.CleartkSequenceAnnotator;
import org.cleartk.classifier.DataWriter;
import org.cleartk.classifier.SequenceDataWriter;
import org.cleartk.classifier.jar.DefaultDataWriterFactory;
import org.cleartk.classifier.jar.DefaultSequenceDataWriterFactory;
import org.cleartk.classifier.jar.DirectoryDataWriterFactory;
import org.cleartk.classifier.jar.GenericJarClassifierFactory;
import org.cleartk.classifier.jar.JarClassifierBuilder;
import org.cleartk.classifier.jar.Train;
import org.cleartk.classifier.viterbi.DefaultOutcomeFeatureExtractor;
import org.cleartk.classifier.viterbi.ViterbiDataWriterFactory;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.TemporalLink;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.util.JCasUtil;

class Model<ANNOTATION_TYPE extends TOP> {
    public static final File DEFAULT_DIRECTORY = null;
    public String name;
    public List<Model<?>> prerequisites;
    private Class<? extends AnalysisComponent> annotatorClass;
    public Params bestParams;
    public List<Params> paramsToSearch;
    private EvaluationType evaluationType;
    private LoggingType loggingType;
    private Class<ANNOTATION_TYPE> annotationClass;
    Function<ANNOTATION_TYPE, ?> annotationToSpan;
    private Function<ANNOTATION_TYPE, String> annotationToOutcome;
    private String featureToRemove;

    public Model(String name, List<Model<?>> prerequisites, Class<? extends AnalysisComponent> annotatorClass, Params bestParams, List<Params> paramsToSearch, EvaluationType evaluationType, LoggingType loggingType, Class<ANNOTATION_TYPE> annotationClass, Function<ANNOTATION_TYPE, ?> annotationToSpan, Function<ANNOTATION_TYPE, String> annotationToOutcome, String featureToRemove) {
        this.name = name;
        this.prerequisites = prerequisites;
        this.annotatorClass = annotatorClass;
        this.bestParams = bestParams;
        this.paramsToSearch = paramsToSearch;
        this.evaluationType = evaluationType;
        this.loggingType = loggingType;
        this.annotationClass = annotationClass;
        this.annotationToSpan = annotationToSpan;
        this.annotationToOutcome = annotationToOutcome;
        this.featureToRemove = featureToRemove;
    }

    public String toString() {
        Objects.ToStringHelper helper = Objects.toStringHelper(this.getClass());
        helper.add("name", (Object)this.name);
        return helper.toString();
    }

    public AnalysisEngineDescription getWriterDescription(File directory, Params params) throws ResourceInitializationException {
        AnalysisEngineDescription desc;
        if (params.nViterbiOutcomes > 0) {
            desc = AnalysisEngineFactory.createPrimitiveDescription(this.annotatorClass, (Object[])new Object[]{CleartkSequenceAnnotator.PARAM_DATA_WRITER_FACTORY_CLASS_NAME, ViterbiDataWriterFactory.class, ViterbiDataWriterFactory.PARAM_DELEGATED_DATA_WRITER_FACTORY_CLASS, DefaultDataWriterFactory.class, DefaultDataWriterFactory.PARAM_DATA_WRITER_CLASS_NAME, params.dataWriterClass, ViterbiDataWriterFactory.PARAM_OUTCOME_FEATURE_EXTRACTOR_NAMES, DefaultOutcomeFeatureExtractor.class, DefaultOutcomeFeatureExtractor.PARAM_MOST_RECENT_OUTCOME, 1, DefaultOutcomeFeatureExtractor.PARAM_LEAST_RECENT_OUTCOME, params.nViterbiOutcomes, DirectoryDataWriterFactory.PARAM_OUTPUT_DIRECTORY, this.getModelDirectory(directory, params)});
        } else {
            String datatWriterParamName;
            if (SequenceDataWriter.class.isAssignableFrom(params.dataWriterClass)) {
                datatWriterParamName = DefaultSequenceDataWriterFactory.PARAM_DATA_WRITER_CLASS_NAME;
            } else if (DataWriter.class.isAssignableFrom(params.dataWriterClass)) {
                datatWriterParamName = DefaultDataWriterFactory.PARAM_DATA_WRITER_CLASS_NAME;
            } else {
                throw new RuntimeException("Invalid data writer class: " + params.dataWriterClass);
            }
            desc = AnalysisEngineFactory.createPrimitiveDescription(this.annotatorClass, (Object[])new Object[]{datatWriterParamName, params.dataWriterClass, DirectoryDataWriterFactory.PARAM_OUTPUT_DIRECTORY, this.getModelDirectory(directory, params)});
        }
        return desc;
    }

    public void train(File directory, Params params) throws Exception {
        Train.main((File)this.getModelDirectory(directory, params), (String[])params.trainingArguments);
    }

    public void cleanTrainingFiles(File directory, Params params) {
        this.cleanTrainingFiles(this.getModelDirectory(directory, params));
    }

    private void cleanTrainingFiles(File directory) {
        File modelJarFile = JarClassifierBuilder.getModelJarFile((File)directory);
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.cleanTrainingFiles(file);
            }
            if (file.equals(modelJarFile)) continue;
            file.delete();
        }
    }

    public AnalysisEngineDescription getAnnotatorDescription(File directory, Params params) throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(this.annotatorClass, (Object[])new Object[]{GenericJarClassifierFactory.PARAM_CLASSIFIER_JAR_PATH, JarClassifierBuilder.getModelJarFile((File)this.getModelDirectory(directory, params))});
    }

    public void evaluate(JCas goldView, JCas systemView, AnnotationStatistics<String> stats) {
        HashSet spans;
        ArrayList goldAnnotations = this.select(goldView);
        ArrayList systemAnnotations = this.select(systemView);
        switch (this.evaluationType) {
            case NORMAL: {
                spans = null;
                break;
            }
            case GOLD_SPANS: {
                spans = Sets.newHashSet((Iterable)Iterables.transform(this.select(goldView), this.annotationToSpan));
                break;
            }
            case SYSTEM_SPANS: {
                spans = Sets.newHashSet((Iterable)Iterables.transform(this.select(systemView), this.annotationToSpan));
                break;
            }
            case INTERSECTED_SPANS: {
                spans = Sets.intersection((Set)Sets.newHashSet((Iterable)Iterables.transform(this.select(goldView), this.annotationToSpan)), (Set)Sets.newHashSet((Iterable)Iterables.transform(this.select(systemView), this.annotationToSpan)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown evaluation type: " + (Object)((Object)this.evaluationType));
            }
        }
        if (spans != null) {
            Predicate isSelectedSpan = new Predicate<ANNOTATION_TYPE>(){

                public boolean apply(ANNOTATION_TYPE annotation) {
                    return spans.contains(Model.this.annotationToSpan.apply(annotation));
                }
            };
            goldAnnotations = Lists.newArrayList((Iterable)Iterables.filter(goldAnnotations, (Predicate)isSelectedSpan));
            systemAnnotations = Lists.newArrayList((Iterable)Iterables.filter(systemAnnotations, (Predicate)isSelectedSpan));
        }
        switch (this.loggingType) {
            case NONE: {
                break;
            }
            case SYSTEM_PREDICTIONS: {
                HashMap goldMap = Maps.newHashMap();
                for (TOP annotation : goldAnnotations) {
                    goldMap.put(this.annotationToSpan.apply((Object)annotation), annotation);
                }
                HashMap systemMap = Maps.newHashMap();
                for (TOP annotation : systemAnnotations) {
                    systemMap.put(this.annotationToSpan.apply((Object)annotation), annotation);
                }
                for (Object span : Sets.union(goldMap.keySet(), systemMap.keySet())) {
                    String systemOutcome;
                    TOP goldAnnotation = (TOP)goldMap.get(span);
                    TOP systemAnnotation = (TOP)systemMap.get(span);
                    String goldOutcome = goldAnnotation == null ? null : (String)this.annotationToOutcome.apply((Object)goldAnnotation);
                    String string = systemOutcome = systemAnnotation == null ? null : (String)this.annotationToOutcome.apply((Object)systemAnnotation);
                    if (goldAnnotation == null) {
                        System.err.printf("%s: System added %s\n", this.name, this.format(systemAnnotation));
                        continue;
                    }
                    if (systemAnnotation == null) {
                        System.err.printf("%s: System missed %s\n", this.name, this.format(goldAnnotation));
                        continue;
                    }
                    if (!goldOutcome.equals(systemOutcome)) {
                        String message = "%s: System misclassified %s as %s\n";
                        System.err.printf(message, this.name, goldOutcome, this.format(systemAnnotation));
                        continue;
                    }
                    System.err.printf("%s: System found %s\n", this.name, this.format(systemAnnotation));
                }
                break;
            }
        }
        stats.add((Collection)goldAnnotations, systemAnnotations, this.annotationToSpan, this.annotationToOutcome);
    }

    private String format(ANNOTATION_TYPE annotation) {
        return this.format((TOP)annotation, (String)this.annotationToOutcome.apply(annotation));
    }

    private String format(TOP top, String outcome) {
        String result;
        String text = top.getCAS().getDocumentText().replaceAll("[\r\n]", " ");
        int nChars = 30;
        if (top instanceof TemporalLink) {
            TemporalLink link = (TemporalLink)top;
            Anchor source = link.getSource();
            Anchor target = link.getTarget();
            result = String.format("%s(%s, %s)", link.getRelationType(), this.format((TOP)source, null), this.format((TOP)target, null));
        } else if (top instanceof Annotation) {
            Annotation annotation = (Annotation)top;
            int begin = annotation.getBegin();
            int end = annotation.getEnd();
            int preBegin = Math.max(begin - nChars, 0);
            int postEnd = Math.min(end + nChars, text.length());
            result = String.format("...%s[%s%s]%s...", text.substring(preBegin, begin), text.substring(begin, end), outcome == null ? "" : "=" + outcome, text.substring(end, postEnd));
        } else {
            throw new IllegalArgumentException("unsupported annotation type: " + top);
        }
        return result;
    }

    public Map<ANNOTATION_TYPE, String> removeModelAnnotations(JCas jCas) {
        HashMap annotations = Maps.newHashMap();
        for (TOP annotation : this.select(jCas)) {
            if (this.featureToRemove != null) {
                Feature feature = annotation.getType().getFeatureByBaseName(this.featureToRemove);
                annotations.put(annotation, annotation.getFeatureValueAsString(feature));
                annotation.setFeatureValueFromString(feature, null);
                continue;
            }
            annotations.put(annotation, null);
            annotation.removeFromIndexes();
        }
        return annotations;
    }

    public void restoreModelAnnotations(JCas jCas, Map<? extends TOP, String> annotations) {
        for (TOP tOP : annotations.keySet()) {
            String value = annotations.get(tOP);
            if (this.featureToRemove != null) {
                if (value == null) continue;
                Feature feature = tOP.getType().getFeatureByBaseName(this.featureToRemove);
                tOP.setFeatureValueFromString(feature, value);
                continue;
            }
            tOP.addToIndexes();
        }
    }

    private List<ANNOTATION_TYPE> select(JCas jCas) {
        ArrayList annotations = Lists.newArrayList();
        for (TOP annotation : JCasUtil.select((JCas)jCas, this.annotationClass)) {
            if (!annotation.getClass().equals(this.annotationClass)) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    private File getModelDirectory(File directory, Params params) {
        if (directory == DEFAULT_DIRECTORY) {
            String path = this.annotatorClass.getName().toLowerCase().replace('.', '/');
            return new File("src/main/resources/" + path);
        }
        String dataWriterName = params.dataWriterClass.getSimpleName();
        String viterbi = params.nViterbiOutcomes > 0 ? "viterbi" + params.nViterbiOutcomes + "_" : "";
        String fileName = viterbi + Joiner.on((String)"_").join((Object[])params.trainingArguments);
        return new File(new File(new File(directory, this.name), dataWriterName), fileName);
    }

    public static enum LoggingType {
        NONE,
        SYSTEM_PREDICTIONS;

    }

    public static enum EvaluationType {
        NORMAL,
        GOLD_SPANS,
        SYSTEM_SPANS,
        INTERSECTED_SPANS;

    }

    public static class Params {
        public Class<?> dataWriterClass;
        public int nViterbiOutcomes;
        public String[] trainingArguments;

        public Params(Class<?> dataWriterClass, String ... trainingArguments) {
            this(dataWriterClass, 0, trainingArguments);
        }

        public Params(Class<?> dataWriterClass, int nViterbiOutcomes, String ... trainingArguments) {
            this.dataWriterClass = dataWriterClass;
            this.nViterbiOutcomes = nViterbiOutcomes;
            this.trainingArguments = trainingArguments;
        }

        public String toString() {
            Objects.ToStringHelper helper = Objects.toStringHelper(this.getClass());
            helper.add("dataWriterClass", (Object)this.dataWriterClass.getSimpleName());
            if (this.nViterbiOutcomes > 0) {
                helper.add("nViterbiOutcomes", this.nViterbiOutcomes);
            }
            if (this.trainingArguments.length > 0) {
                helper.add("trainingArguments", (Object)Joiner.on((char)' ').join((Object[])this.trainingArguments));
            }
            return helper.toString();
        }
    }
}

