/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.eval;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.uima.jcas.JCas;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.timeml.eval.ModelInfo;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.TemporalLink;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.uimafit.util.JCasUtil;

public class TemporalLinkModelInfo
extends ModelInfo<TemporalLink> {
    public TemporalLinkModelInfo(CleartkInternalModelFactory modelFactory, String[] trainingArguments) {
        super(TemporalLink.class, "relationType", TemporalLinkSpan.FROM_TEMPORAL_LINK, modelFactory, trainingArguments);
    }

    public TemporalLinkModelInfo(CleartkInternalModelFactory modelFactory) {
        this(modelFactory, new String[0]);
    }

    @Override
    public void updateStatistics(AnnotationStatistics<String> statistics, JCas goldView, JCas systemView) {
        Collection goldTlinks = JCasUtil.select((JCas)goldView, (Class)this.annotatedClass);
        HashSet<Object> goldSpans = new HashSet<Object>();
        for (TemporalLink tlink : goldTlinks) {
            goldSpans.add(this.getSpan.apply((Object)tlink));
        }
        ArrayList<TemporalLink> systemTlinks = new ArrayList<TemporalLink>();
        for (TemporalLink tlink : JCasUtil.select((JCas)systemView, (Class)this.annotatedClass)) {
            if (!goldSpans.contains(this.getSpan.apply((Object)tlink))) continue;
            systemTlinks.add(tlink);
        }
        statistics.add(goldTlinks, systemTlinks, this.getSpan, this.getOutcome);
    }

    private static class TemporalLinkSpan {
        public static final Function<TemporalLink, TemporalLinkSpan> FROM_TEMPORAL_LINK = new Function<TemporalLink, TemporalLinkSpan>(){

            public TemporalLinkSpan apply(TemporalLink tlink) {
                return new TemporalLinkSpan(tlink);
            }
        };
        private int sourceBegin;
        private int sourceEnd;
        private int targetBegin;
        private int targetEnd;

        public TemporalLinkSpan(TemporalLink tlink) {
            Anchor source = tlink.getSource();
            Anchor target = tlink.getTarget();
            this.sourceBegin = source.getBegin();
            this.sourceEnd = source.getEnd();
            this.targetBegin = target.getBegin();
            this.targetEnd = target.getEnd();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.sourceBegin, this.sourceEnd, this.targetBegin, this.targetEnd});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TemporalLinkSpan that = (TemporalLinkSpan)obj;
            return this.sourceBegin == that.sourceBegin && this.sourceEnd == that.sourceEnd && this.targetBegin == that.targetBegin && this.targetEnd == that.targetEnd;
        }
    }
}

