/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.event;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.CleartkAnnotator;
import org.cleartk.classifier.Instance;
import org.cleartk.classifier.feature.extractor.CleartkExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.timeml.type.Event;
import org.cleartk.token.type.Sentence;
import org.uimafit.util.JCasUtil;

public abstract class EventAttributeAnnotator<OUTCOME_TYPE>
extends CleartkAnnotator<OUTCOME_TYPE> {
    protected List<SimpleFeatureExtractor> eventFeatureExtractors;
    protected List<CleartkExtractor> contextExtractors;

    protected abstract OUTCOME_TYPE getDefaultValue();

    protected abstract OUTCOME_TYPE getAttribute(Event var1);

    protected abstract void setAttribute(Event var1, OUTCOME_TYPE var2);

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.eventFeatureExtractors = new ArrayList<SimpleFeatureExtractor>();
        this.contextExtractors = new ArrayList<CleartkExtractor>();
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            for (Event event : JCasUtil.selectCovered((JCas)jCas, Event.class, (AnnotationFS)sentence)) {
                ArrayList features = new ArrayList();
                for (SimpleFeatureExtractor simpleFeatureExtractor : this.eventFeatureExtractors) {
                    features.addAll(simpleFeatureExtractor.extract(jCas, (Annotation)event));
                }
                for (CleartkExtractor cleartkExtractor : this.contextExtractors) {
                    features.addAll(cleartkExtractor.extractWithin(jCas, (Annotation)event, (Annotation)sentence));
                }
                if (this.isTraining()) {
                    OUTCOME_TYPE attribute = this.getAttribute(event);
                    if (attribute == null) {
                        attribute = this.getDefaultValue();
                    }
                    Instance instance = new Instance();
                    instance.addAll(features);
                    instance.setOutcome(attribute);
                    this.dataWriter.write(instance);
                    continue;
                }
                Object label = this.classifier.classify(features);
                this.setAttribute(event, label);
            }
        }
    }
}

