/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.time;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.CleartkSequenceAnnotator;
import org.cleartk.classifier.Instances;
import org.cleartk.classifier.chunking.BIOChunking;
import org.cleartk.classifier.feature.extractor.CleartkExtractor;
import org.cleartk.classifier.feature.extractor.simple.CharacterCategoryPatternExtractor;
import org.cleartk.classifier.feature.extractor.simple.CoveredTextExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleNamedFeatureExtractor;
import org.cleartk.classifier.feature.extractor.simple.TypePathExtractor;
import org.cleartk.classifier.liblinear.LIBLINEARStringOutcomeDataWriter;
import org.cleartk.timeml.type.Time;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.cleartk.timeml.util.TimeWordsExtractor;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.util.JCasUtil;

public class TimeAnnotator
extends CleartkSequenceAnnotator<String> {
    public static final CleartkInternalModelFactory FACTORY = new CleartkInternalModelFactory(){

        @Override
        public Class<?> getAnnotatorClass() {
            return TimeAnnotator.class;
        }

        @Override
        public Class<?> getDataWriterClass() {
            return LIBLINEARStringOutcomeDataWriter.class;
        }

        @Override
        public AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createPrimitiveDescription(TimeAnnotator.class, (Object[])new Object[0]);
        }
    };
    private List<SimpleNamedFeatureExtractor> tokenFeatureExtractors;
    private List<CleartkExtractor> contextFeatureExtractors;
    private BIOChunking<Token, Time> chunking;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.chunking = new BIOChunking(Token.class, Time.class);
        this.tokenFeatureExtractors = Arrays.asList(new CoveredTextExtractor(), new CharacterCategoryPatternExtractor(CharacterCategoryPatternExtractor.PatternType.REPEATS_MERGED), new TimeWordsExtractor(), new TypePathExtractor(Token.class, "stem"), new TypePathExtractor(Token.class, "pos"));
        this.contextFeatureExtractors = new ArrayList<CleartkExtractor>();
        for (SimpleFeatureExtractor simpleFeatureExtractor : this.tokenFeatureExtractors) {
            this.contextFeatureExtractors.add(new CleartkExtractor(Token.class, simpleFeatureExtractor, new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(3), new CleartkExtractor.Following(3)}));
        }
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            List tokens = JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)sentence);
            ArrayList featureLists = new ArrayList();
            for (Token token : tokens) {
                ArrayList features = new ArrayList();
                for (SimpleFeatureExtractor simpleFeatureExtractor : this.tokenFeatureExtractors) {
                    features.addAll(simpleFeatureExtractor.extract(jCas, (Annotation)token));
                }
                for (CleartkExtractor cleartkExtractor : this.contextFeatureExtractors) {
                    features.addAll(cleartkExtractor.extractWithin(jCas, (Annotation)token, (Annotation)sentence));
                }
                featureLists.add(features);
            }
            if (this.isTraining()) {
                List times = JCasUtil.selectCovered((JCas)jCas, Time.class, (AnnotationFS)sentence);
                List outcomes = this.chunking.createOutcomes(jCas, tokens, times);
                this.dataWriter.write(Instances.toInstances((List)outcomes, featureLists));
                continue;
            }
            List outcomes = this.classifier.classify(featureLists);
            this.chunking.createChunks(jCas, tokens, outcomes);
        }
        int timeIndex = 1;
        for (Time time : JCasUtil.select((JCas)jCas, Time.class)) {
            if (time.getId() != null) continue;
            String id = String.format("t%d", timeIndex);
            time.setId(id);
            ++timeIndex;
        }
    }
}

