/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.tlink;

import com.google.common.base.Function;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.util.Level;
import org.cleartk.classifier.CleartkAnnotator;
import org.cleartk.classifier.Instance;
import org.cleartk.classifier.feature.extractor.BetweenAnnotationsFeatureExtractor;
import org.cleartk.classifier.feature.extractor.simple.NamingExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.syntax.constituent.type.TreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNodeUtil;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.TemporalLink;
import org.cleartk.token.type.Sentence;
import org.uimafit.util.JCasUtil;

public abstract class TemporalLinkAnnotator_ImplBase<SOURCE extends Anchor, TARGET extends Anchor>
extends CleartkAnnotator<String> {
    public static Map<String, String> REVERSE_RELATION = new HashMap<String, String>();
    private Class<SOURCE> sourceClass;
    private Class<TARGET> targetClass;
    private Set<String> trainingRelationTypes;
    private static final String NO_RELATION = "-NO-RELATION-";
    protected List<SimpleFeatureExtractor> sourceExtractors;
    protected List<SimpleFeatureExtractor> targetExtractors;
    protected List<BetweenAnnotationsFeatureExtractor> betweenExtractors;

    public TemporalLinkAnnotator_ImplBase(Class<SOURCE> sourceClass, Class<TARGET> targetClass, String ... trainingRelationTypes) {
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
        this.trainingRelationTypes = new HashSet<String>(Arrays.asList(trainingRelationTypes));
        this.sourceExtractors = new ArrayList<SimpleFeatureExtractor>();
        this.targetExtractors = new ArrayList<SimpleFeatureExtractor>();
        this.betweenExtractors = new ArrayList<BetweenAnnotationsFeatureExtractor>();
    }

    protected void setSourceExtractors(List<SimpleFeatureExtractor> extractors) {
        this.sourceExtractors = new ArrayList<SimpleFeatureExtractor>();
        for (SimpleFeatureExtractor extractor : extractors) {
            this.sourceExtractors.add((SimpleFeatureExtractor)new NamingExtractor("Source", extractor));
        }
    }

    protected void setTargetExtractors(List<SimpleFeatureExtractor> extractors) {
        this.targetExtractors = new ArrayList<SimpleFeatureExtractor>();
        for (SimpleFeatureExtractor extractor : extractors) {
            this.targetExtractors.add((SimpleFeatureExtractor)new NamingExtractor("Target", extractor));
        }
    }

    protected void setBetweenExtractors(List<BetweenAnnotationsFeatureExtractor> extractors) {
        this.betweenExtractors = extractors;
    }

    protected abstract List<SourceTargetPair> getSourceTargetPairs(JCas var1);

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        HashBasedTable links = HashBasedTable.create();
        for (TemporalLink tlink : JCasUtil.select((JCas)jCas, TemporalLink.class)) {
            String relation;
            Anchor target;
            Anchor source;
            Anchor sourceAnchor = tlink.getSource();
            Anchor targetAnchor = tlink.getTarget();
            if (this.sourceClass.isInstance(sourceAnchor) && this.targetClass.isInstance(targetAnchor)) {
                source = (Anchor)this.sourceClass.cast(sourceAnchor);
                target = (Anchor)this.targetClass.cast(targetAnchor);
                relation = tlink.getRelationType();
                links.put((Object)source, (Object)target, (Object)relation);
            }
            if (!this.sourceClass.isInstance(targetAnchor) || !this.targetClass.isInstance(sourceAnchor)) continue;
            source = (Anchor)this.sourceClass.cast(targetAnchor);
            target = (Anchor)this.targetClass.cast(sourceAnchor);
            relation = REVERSE_RELATION.get(tlink.getRelationType());
            if (relation == null) {
                throw new UnsupportedOperationException("Unknown relation: " + tlink.getRelationType());
            }
            links.put((Object)source, (Object)target, (Object)relation);
        }
        for (SourceTargetPair pair : this.getSourceTargetPairs(jCas)) {
            String relation;
            Object source = pair.source;
            Object target = pair.target;
            ArrayList features = new ArrayList();
            for (SimpleFeatureExtractor extractor : this.sourceExtractors) {
                features.addAll(extractor.extract(jCas, source));
            }
            for (SimpleFeatureExtractor extractor : this.targetExtractors) {
                features.addAll(extractor.extract(jCas, target));
            }
            for (BetweenAnnotationsFeatureExtractor extractor : this.betweenExtractors) {
                features.addAll(extractor.extractBetween(jCas, source, target));
            }
            if (this.isTraining()) {
                relation = (String)links.remove(source, target);
                if (relation == null) continue;
                if (!this.trainingRelationTypes.isEmpty() && !this.trainingRelationTypes.contains(relation)) {
                    relation = NO_RELATION;
                }
                this.dataWriter.write(new Instance((Object)relation, features));
                continue;
            }
            relation = (String)this.classifier.classify(features);
            if (NO_RELATION.equals(relation)) continue;
            int offset = jCas.getDocumentText().length();
            TemporalLink tlink = new TemporalLink(jCas, offset, offset);
            tlink.setSource(source);
            tlink.setTarget(target);
            tlink.setRelationType(relation);
            tlink.addToIndexes();
        }
        if (!links.isEmpty()) {
            HashMap<Anchor, Sentence> sentences = new HashMap<Anchor, Sentence>();
            for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
                for (Anchor source : JCasUtil.selectCovered((JCas)jCas, this.sourceClass, (AnnotationFS)sentence)) {
                    sentences.put(source, sentence);
                }
                for (Anchor target : JCasUtil.selectCovered((JCas)jCas, this.targetClass, (AnnotationFS)sentence)) {
                    sentences.put(target, sentence);
                }
            }
            ArrayList cells = Lists.newArrayList((Iterable)links.cellSet());
            Ordering order = Ordering.natural().onResultOf(new Function<Table.Cell<SOURCE, TARGET, String>, Integer>(){

                public Integer apply(Table.Cell<SOURCE, TARGET, String> cell) {
                    return ((Anchor)cell.getRowKey()).getBegin();
                }
            });
            Collections.sort(cells, order);
            StringBuilder errorBuilder = new StringBuilder();
            errorBuilder.append("Missed ").append(links.size()).append(" TLINK(s)\n");
            for (Table.Cell cell : cells) {
                Anchor source = (Anchor)cell.getRowKey();
                Anchor target = (Anchor)cell.getColumnKey();
                String relation = (String)cell.getValue();
                Sentence sent1 = (Sentence)sentences.get(source);
                Sentence sent2 = (Sentence)sentences.get(target);
                errorBuilder.append(String.format("%s(%s, %s)\n%s\n%s\n", relation, source.getCoveredText(), target.getCoveredText(), sent1 == null ? null : sent1.getCoveredText(), sent2 == null ? null : sent2.getCoveredText()));
            }
            this.getContext().getLogger().log(Level.FINE, errorBuilder.toString());
        }
    }

    protected static String noLeavesPath(TreebankNodeUtil.TreebankNodePath path) {
        if (path.getCommonAncestor() == null) {
            return null;
        }
        ArrayList<String> sourceTypes = new ArrayList<String>();
        for (TreebankNode node : path.getSourceToAncestorPath()) {
            if (node.getLeaf()) continue;
            sourceTypes.add(node.getNodeType());
        }
        ArrayList<String> targetTypes = new ArrayList<String>();
        for (TreebankNode node : path.getTargetToAncestorPath()) {
            if (node.getLeaf()) continue;
            targetTypes.add(node.getNodeType());
        }
        Collections.reverse(targetTypes);
        StringBuilder builder = new StringBuilder();
        for (String type : sourceTypes) {
            builder.append(type).append('>');
        }
        builder.append(path.getCommonAncestor().getNodeType());
        for (String type : targetTypes) {
            builder.append('<').append(type);
        }
        return builder.toString();
    }

    static {
        REVERSE_RELATION.put("BEFORE", "AFTER");
        REVERSE_RELATION.put("AFTER", "BEFORE");
        REVERSE_RELATION.put("INCLUDES", "IS_INCLUDED");
        REVERSE_RELATION.put("IS_INCLUDED", "INCLUDES");
        REVERSE_RELATION.put("DURING", "DURING_INV");
        REVERSE_RELATION.put("DURING_INV", "DURING");
        REVERSE_RELATION.put("SIMULTANEOUS", "SIMULTANEOUS");
        REVERSE_RELATION.put("IAFTER", "IBEFORE");
        REVERSE_RELATION.put("IBEFORE", "IAFTER");
        REVERSE_RELATION.put("IDENTITY", "IDENTITY");
        REVERSE_RELATION.put("BEGINS", "BEGUN_BY");
        REVERSE_RELATION.put("ENDS", "ENDED_BY");
        REVERSE_RELATION.put("BEGUN_BY", "BEGINS");
        REVERSE_RELATION.put("ENDED_BY", "ENDS");
        REVERSE_RELATION.put("OVERLAP", "OVERLAP");
        REVERSE_RELATION.put("OVERLAP-OR-AFTER", "BEFORE-OR-OVERLAP");
        REVERSE_RELATION.put("BEFORE-OR-OVERLAP", "OVERLAP-OR-AFTER");
        REVERSE_RELATION.put("VAGUE", "VAGUE");
        REVERSE_RELATION.put("UNKNOWN", "UNKNOWN");
        REVERSE_RELATION.put("NONE", "NONE");
    }

    protected static class SourceTargetPair {
        public SOURCE source;
        public TARGET target;
        final /* synthetic */ TemporalLinkAnnotator_ImplBase this$0;

        public SourceTargetPair(SOURCE source, TARGET target) {
            this.this$0 = var1_1;
            this.source = source;
            this.target = target;
        }
    }
}

