/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.tlink;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.feature.extractor.simple.CoveredTextExtractor;
import org.cleartk.classifier.feature.extractor.simple.SimpleFeatureExtractor;
import org.cleartk.classifier.feature.extractor.simple.TypePathExtractor;
import org.cleartk.classifier.liblinear.LIBLINEARStringOutcomeDataWriter;
import org.cleartk.feature.FilteringExtractor;
import org.cleartk.timeml.tlink.TemporalLinkAnnotator_ImplBase;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.DocumentCreationTime;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.cleartk.token.type.Sentence;
import org.uimafit.factory.AnalysisEngineFactory;
import org.uimafit.util.JCasUtil;

public class TemporalLinkEventToDocumentCreationTimeAnnotator
extends TemporalLinkAnnotator_ImplBase<Event, DocumentCreationTime> {
    public static final CleartkInternalModelFactory FACTORY = new CleartkInternalModelFactory(){

        @Override
        public Class<?> getAnnotatorClass() {
            return TemporalLinkEventToDocumentCreationTimeAnnotator.class;
        }

        @Override
        public Class<?> getDataWriterClass() {
            return LIBLINEARStringOutcomeDataWriter.class;
        }

        @Override
        public AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createPrimitiveDescription(TemporalLinkEventToDocumentCreationTimeAnnotator.class, (Object[])new Object[0]);
        }
    };

    public TemporalLinkEventToDocumentCreationTimeAnnotator() {
        super(Event.class, DocumentCreationTime.class, "BEFORE", "AFTER", "INCLUDES");
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.setSourceExtractors(Arrays.asList(new TypePathExtractor(Event.class, "tense"), new TypePathExtractor(Event.class, "aspect"), new TypePathExtractor(Event.class, "eventClass"), new TypePathExtractor(Event.class, "polarity"), new TypePathExtractor(Event.class, "modality"), new FilteringExtractor<Event>(Event.class, (SimpleFeatureExtractor)new CoveredTextExtractor()){

            protected boolean accept(Event event) {
                return event.getEventClass().equals("ASPECTUAL");
            }
        }));
    }

    @Override
    protected List<TemporalLinkAnnotator_ImplBase.SourceTargetPair> getSourceTargetPairs(JCas jCas) {
        ArrayList pairs = Lists.newArrayList();
        DocumentCreationTime dct = (DocumentCreationTime)JCasUtil.selectSingle((JCas)jCas, DocumentCreationTime.class);
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            for (Event event : JCasUtil.selectCovered((JCas)jCas, Event.class, (AnnotationFS)sentence)) {
                pairs.add(new TemporalLinkAnnotator_ImplBase.SourceTargetPair((TemporalLinkAnnotator_ImplBase)this, (Anchor)event, (Anchor)dct));
            }
        }
        return pairs;
    }
}

