/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.util;

import java.io.File;
import java.net.URL;
import java.util.MissingResourceException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.classifier.DataWriter;
import org.cleartk.classifier.SequenceDataWriter;
import org.cleartk.classifier.jar.DefaultDataWriterFactory;
import org.cleartk.classifier.jar.DefaultSequenceDataWriterFactory;
import org.cleartk.classifier.jar.DirectoryDataWriterFactory;
import org.cleartk.classifier.jar.GenericJarClassifierFactory;
import org.cleartk.classifier.jar.JarClassifierBuilder;
import org.uimafit.factory.ResourceCreationSpecifierFactory;

public abstract class CleartkInternalModelFactory {
    public abstract AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException;

    public abstract Class<?> getAnnotatorClass();

    public abstract Class<?> getDataWriterClass();

    public File getTrainingDirectory() {
        String path = this.getAnnotatorClass().getName().toLowerCase().replace('.', '/');
        return new File("src/main/resources/" + path);
    }

    public URL getClassifierJarURL() {
        String resourceName = JarClassifierBuilder.getModelJarFile((String)this.getAnnotatorClass().getSimpleName().toLowerCase()).getPath();
        URL url = this.getAnnotatorClass().getResource(resourceName);
        if (url == null) {
            String className = this.getAnnotatorClass().getName();
            String format = "No classifier jar found at \"%s\" for class %s";
            String message = String.format(format, resourceName, className);
            throw new MissingResourceException(message, className, resourceName);
        }
        return url;
    }

    public AnalysisEngineDescription getWriterDescription(File outputDirectory) throws ResourceInitializationException {
        String paramName;
        Class<?> dataWriterClass = this.getDataWriterClass();
        if (SequenceDataWriter.class.isAssignableFrom(dataWriterClass)) {
            paramName = DefaultSequenceDataWriterFactory.PARAM_DATA_WRITER_CLASS_NAME;
        } else if (DataWriter.class.isAssignableFrom(dataWriterClass)) {
            paramName = DefaultDataWriterFactory.PARAM_DATA_WRITER_CLASS_NAME;
        } else {
            throw new RuntimeException("Invalid data writer class: " + dataWriterClass);
        }
        AnalysisEngineDescription desc = this.getBaseDescription();
        ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceCreationSpecifier)desc, (Object[])new Object[]{DirectoryDataWriterFactory.PARAM_OUTPUT_DIRECTORY, outputDirectory.getPath(), paramName, dataWriterClass.getName()});
        return desc;
    }

    public AnalysisEngineDescription getWriterDescription() throws ResourceInitializationException {
        return this.getWriterDescription(this.getTrainingDirectory());
    }

    public AnalysisEngineDescription getAnnotatorDescription(String modelFileName) throws ResourceInitializationException {
        AnalysisEngineDescription desc = this.getBaseDescription();
        ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceCreationSpecifier)desc, (Object[])new Object[]{GenericJarClassifierFactory.PARAM_CLASSIFIER_JAR_PATH, modelFileName});
        return desc;
    }

    public AnalysisEngineDescription getAnnotatorDescription() throws ResourceInitializationException {
        return this.getAnnotatorDescription(this.getClassifierJarURL().toString());
    }
}

