/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.eval;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.jcas.JCas;
import org.cleartk.corpus.timeml.TempEval2010CollectionReader;
import org.cleartk.corpus.timeml.TempEval2010GoldAnnotator;
import org.cleartk.corpus.timeml.TempEval2010Writer;
import org.cleartk.eval.AnnotationStatistics;
import org.cleartk.eval.Evaluation_ImplBase;
import org.cleartk.ml.jar.JarClassifierBuilder;
import org.cleartk.timeml.eval.ModelInfo;
import org.cleartk.util.ViewUriUtil;
import org.cleartk.util.ae.XmiWriter;
import org.xml.sax.SAXException;

public class TempEval2010Evaluation
extends Evaluation_ImplBase<String, Map<ModelInfo<?>, AnnotationStatistics<String>>> {
    public static final String GOLD_VIEW_NAME = "GoldView";
    public static final String SYSTEM_VIEW_NAME = "_InitialView";
    private File trainDir;
    private File testDir;
    private List<File> dataDirs;
    private List<String> goldAnnotatorParamsForViewsRequiredBySystem;
    private String goldAnnotatorParamForViewAnnotatedBySystem;
    private String timemlWriterParamForViewAnnotatedBySystem;
    private List<AnalysisEngineDescription> preprocessingAnnotators;
    private List<? extends ModelInfo<?>> modelInfos;

    public TempEval2010Evaluation(File trainDir, File testDir, File outputDirectory, List<String> goldAnnotatorParamsForViewsRequiredBySystem, String goldAnnotatorParamForViewAnnotatedBySystem, String timemlWriterParamForViewAnnotatedBySystem, List<AnalysisEngineDescription> preprocessingAnnotators, List<? extends ModelInfo<?>> modelInfos) throws Exception {
        super(outputDirectory);
        this.trainDir = trainDir;
        this.testDir = testDir;
        this.dataDirs = Arrays.asList(trainDir, testDir);
        this.goldAnnotatorParamsForViewsRequiredBySystem = goldAnnotatorParamsForViewsRequiredBySystem;
        this.goldAnnotatorParamForViewAnnotatedBySystem = goldAnnotatorParamForViewAnnotatedBySystem;
        this.timemlWriterParamForViewAnnotatedBySystem = timemlWriterParamForViewAnnotatedBySystem;
        this.preprocessingAnnotators = preprocessingAnnotators;
        this.modelInfos = modelInfos;
    }

    protected CollectionReader getCollectionReader(List<String> items) throws Exception {
        return TempEval2010CollectionReader.getCollectionReader(this.dataDirs, new HashSet<String>(items));
    }

    protected void train(CollectionReader collectionReader, File directory) throws Exception {
        File modelDir;
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(AnalysisEngineFactory.createEngineDescription(XMIReader.class, (Object[])new Object[]{"xmiDirectory", this.getXMIDirectory(directory, Stage.TRAIN).getPath()}), new String[0]);
        for (ModelInfo<?> modelInfo : this.modelInfos) {
            File outputDir = modelInfo.getModelSubdirectory(directory);
            builder.add(modelInfo.modelFactory.getWriterDescription(outputDir), new String[0]);
        }
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{builder.createAggregateDescription()});
        for (ModelInfo<?> modelInfo : this.modelInfos) {
            modelDir = modelInfo.getModelSubdirectory(directory);
            JarClassifierBuilder.trainAndPackage((File)modelDir, (String[])modelInfo.trainingArguments);
        }
        for (ModelInfo<?> modelInfo : this.modelInfos) {
            modelDir = modelInfo.modelFactory.getTrainingDirectory();
            if (!modelDir.exists()) continue;
            for (File file : modelDir.listFiles()) {
                File modelFile = JarClassifierBuilder.getModelJarFile((File)modelDir);
                if (file.isDirectory() || file.equals(modelFile)) continue;
                file.delete();
            }
        }
    }

    protected Map<ModelInfo<?>, AnnotationStatistics<String>> test(CollectionReader collectionReader, File directory) throws Exception {
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(AnalysisEngineFactory.createEngineDescription(XMIReader.class, (Object[])new Object[]{"xmiDirectory", this.getXMIDirectory(directory, Stage.TEST).getPath()}), new String[0]);
        for (ModelInfo<?> modelInfo : this.modelInfos) {
            File file = JarClassifierBuilder.getModelJarFile((File)modelInfo.getModelSubdirectory(directory));
            builder.add(modelInfo.modelFactory.getAnnotatorDescription(file.getPath()), new String[0]);
        }
        builder.add(AnalysisEngineFactory.createEngineDescription(TempEval2010Writer.class, (Object[])new Object[]{"outputDirectory", new File(directory, "eval").getPath(), "textView", SYSTEM_VIEW_NAME, this.timemlWriterParamForViewAnnotatedBySystem, SYSTEM_VIEW_NAME}), new String[0]);
        HashMap modelInfoToStatistics = new HashMap();
        for (ModelInfo<?> modelInfo : this.modelInfos) {
            modelInfoToStatistics.put(modelInfo, new AnnotationStatistics());
        }
        AnalysisEngine analysisEngine = builder.createAggregate();
        JCasIterator jCasIterator = new JCasIterator(collectionReader, new AnalysisEngine[]{analysisEngine});
        while (jCasIterator.hasNext()) {
            JCas jCas = jCasIterator.next();
            JCas goldView = jCas.getView(GOLD_VIEW_NAME);
            JCas systemView = jCas.getView(SYSTEM_VIEW_NAME);
            for (ModelInfo<?> modelInfo : this.modelInfos) {
                AnnotationStatistics statistics = (AnnotationStatistics)modelInfoToStatistics.get(modelInfo);
                modelInfo.updateStatistics((AnnotationStatistics<String>)statistics, goldView, systemView);
            }
        }
        analysisEngine.collectionProcessComplete();
        return modelInfoToStatistics;
    }

    private File getXMIDirectory(File directory, Stage stage) throws Exception {
        int dotIndex = Math.max(0, this.goldAnnotatorParamForViewAnnotatedBySystem.lastIndexOf(46));
        String name = this.goldAnnotatorParamForViewAnnotatedBySystem.substring(dotIndex + 1);
        File xmiDirectory = new File(new File(new File(directory, "xmi"), name), stage.toString());
        if (!xmiDirectory.exists()) {
            HashSet fileNames = new HashSet();
            fileNames.addAll(TempEval2010CollectionReader.getAnnotatedFileNames((File)this.trainDir));
            fileNames.addAll(TempEval2010CollectionReader.getAnnotatedFileNames((File)this.testDir));
            CollectionReader reader = TempEval2010CollectionReader.getCollectionReader(this.dataDirs, fileNames);
            List<String> viewParams = Arrays.asList("textViews", "documentCreationTimeViews", "timeExtentViews", "timeAttributeViews", "eventExtentViews", "eventAttributeViews", "temporalLinkEventToDocumentCreationTimeViews", "temporalLinkEventToSameSentenceTimeViews", "temporalLinkEventToSubordinatedEventViews", "temporalLinkMainEventToNextSentenceMainEventViews");
            ArrayList<Object> goldAnnotatorParams = new ArrayList<Object>();
            for (String viewParam : viewParams) {
                String[] paramValue;
                goldAnnotatorParams.add(viewParam);
                switch (stage) {
                    case TRAIN: {
                        String[] stringArray;
                        if (this.goldAnnotatorParamsForViewsRequiredBySystem.contains(viewParam) || viewParam.equals(this.goldAnnotatorParamForViewAnnotatedBySystem)) {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = SYSTEM_VIEW_NAME;
                        } else {
                            stringArray = new String[]{};
                        }
                        paramValue = stringArray;
                        break;
                    }
                    case TEST: {
                        if (this.goldAnnotatorParamsForViewsRequiredBySystem.contains(viewParam)) {
                            paramValue = new String[]{SYSTEM_VIEW_NAME, GOLD_VIEW_NAME};
                            break;
                        }
                        if (viewParam.equals(this.goldAnnotatorParamForViewAnnotatedBySystem)) {
                            paramValue = new String[]{GOLD_VIEW_NAME};
                            break;
                        }
                        paramValue = new String[]{};
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                goldAnnotatorParams.add(paramValue);
            }
            AggregateBuilder builder = new AggregateBuilder();
            builder.add(AnalysisEngineFactory.createEngineDescription(TempEval2010GoldAnnotator.class, (Object[])goldAnnotatorParams.toArray()), new String[0]);
            for (AnalysisEngineDescription desc : this.preprocessingAnnotators) {
                builder.add(desc, new String[0]);
            }
            builder.add(AnalysisEngineFactory.createEngineDescription(XmiWriter.class, (Object[])new Object[]{"outputDirectory", xmiDirectory.getPath()}), new String[0]);
            SimplePipeline.runPipeline((CollectionReader)reader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{builder.createAggregateDescription()});
        }
        return xmiDirectory;
    }

    public static class XMIReader
    extends JCasAnnotator_ImplBase {
        @ConfigurationParameter(name="xmiDirectory", mandatory=true)
        protected File xmiDirectory;
        public static final String PARAM_XMI_DIRECTORY = "xmiDirectory";

        protected File getFile(JCas jCas) throws AnalysisEngineProcessException {
            return new File(this.xmiDirectory, ViewUriUtil.getURI((JCas)jCas).getFragment() + ".xmi");
        }

        public void process(JCas jCas) throws AnalysisEngineProcessException {
            try (FileInputStream stream = new FileInputStream(this.getFile(jCas));){
                XmiCasDeserializer.deserialize((InputStream)stream, (CAS)jCas.getCas());
            }
            catch (SAXException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            catch (IOException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }

    private static enum Stage {
        TRAIN,
        TEST;

    }
}

