/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.event;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;
import org.cleartk.ml.liblinear.LibLinearStringOutcomeDataWriter;
import org.cleartk.syntax.constituent.type.TreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNodeUtil;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;

public class EventAnnotator
extends CleartkAnnotator<String> {
    public static final CleartkInternalModelFactory FACTORY = new CleartkInternalModelFactory(){

        @Override
        public Class<?> getAnnotatorClass() {
            return EventAnnotator.class;
        }

        @Override
        public Class<?> getDataWriterClass() {
            return LibLinearStringOutcomeDataWriter.class;
        }

        @Override
        public AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createEngineDescription(EventAnnotator.class, (Object[])new Object[0]);
        }
    };
    protected List<FeatureExtractor1<Token>> tokenFeatureExtractors;
    protected List<CleartkExtractor<Token, Token>> contextExtractors;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.tokenFeatureExtractors = Lists.newArrayList();
        this.tokenFeatureExtractors.add((FeatureExtractor1<Token>)new CoveredTextExtractor());
        this.tokenFeatureExtractors.add((FeatureExtractor1<Token>)new TypePathExtractor(Token.class, "stem"));
        this.tokenFeatureExtractors.add((FeatureExtractor1<Token>)new TypePathExtractor(Token.class, "pos"));
        this.tokenFeatureExtractors.add(new ParentNodeFeaturesExtractor());
        this.contextExtractors = Lists.newArrayList();
        this.contextExtractors.add((CleartkExtractor<Token, Token>)new CleartkExtractor(Token.class, (FeatureExtractor1)new CoveredTextExtractor(), new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(3), new CleartkExtractor.Following(3)}));
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        HashSet<Token> eventTokens = new HashSet<Token>();
        if (this.isTraining()) {
            for (Event event : JCasUtil.select((JCas)jCas, Event.class)) {
                for (Token token : JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)event)) {
                    eventTokens.add(token);
                }
            }
        }
        int index = 1;
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            for (Token token : JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)sentence)) {
                ArrayList features = new ArrayList();
                for (FeatureExtractor1<Token> featureExtractor1 : this.tokenFeatureExtractors) {
                    features.addAll(featureExtractor1.extract(jCas, (Annotation)token));
                }
                for (CleartkExtractor cleartkExtractor : this.contextExtractors) {
                    features.addAll(cleartkExtractor.extractWithin(jCas, (Annotation)token, (Annotation)sentence));
                }
                if (this.isTraining()) {
                    String label = eventTokens.contains(token) ? "Event" : "O";
                    this.dataWriter.write(new Instance((Object)label, features));
                    continue;
                }
                if (!((String)this.classifier.classify(features)).equals("Event")) continue;
                Event event = new Event(jCas, token.getBegin(), token.getEnd());
                event.setId(String.format("e%d", index));
                event.setEventInstanceID(String.format("ei%d", index));
                event.addToIndexes();
                ++index;
            }
        }
    }

    private static class ParentNodeFeaturesExtractor
    implements FeatureExtractor1<Token> {
        public List<Feature> extract(JCas view, Token token) throws CleartkExtractorException {
            TreebankNode parent;
            TreebankNode node = TreebankNodeUtil.selectMatchingLeaf((JCas)view, (Annotation)token);
            ArrayList<Feature> features = new ArrayList<Feature>();
            if (node != null && (parent = node.getParent()) != null) {
                features.add(new Feature("ParentNodeType", (Object)parent.getNodeType()));
                TreebankNode firstSibling = parent.getChildren(0);
                if (firstSibling != node && firstSibling.getLeaf()) {
                    features.add(new Feature("FirstSiblingText", (Object)firstSibling.getCoveredText()));
                }
            }
            return features;
        }
    }
}

