/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.tlink;

import com.google.common.base.Function;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.util.Level;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.FeatureExtractor2;
import org.cleartk.ml.feature.extractor.NamingExtractor1;
import org.cleartk.syntax.constituent.type.TreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNodeUtil;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.TemporalLink;
import org.cleartk.token.type.Sentence;

public abstract class TemporalLinkAnnotator_ImplBase<SOURCE extends Anchor, TARGET extends Anchor>
extends CleartkAnnotator<String> {
    public static Map<String, String> REVERSE_RELATION = new HashMap<String, String>();
    private Class<SOURCE> sourceClass;
    private Class<TARGET> targetClass;
    private Set<String> trainingRelationTypes;
    private static final String NO_RELATION = "-NO-RELATION-";
    protected List<FeatureExtractor1<SOURCE>> sourceExtractors;
    protected List<FeatureExtractor1<TARGET>> targetExtractors;
    protected List<FeatureExtractor2<Anchor, Anchor>> betweenExtractors;

    public TemporalLinkAnnotator_ImplBase(Class<SOURCE> sourceClass, Class<TARGET> targetClass, String ... trainingRelationTypes) {
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
        this.trainingRelationTypes = new HashSet<String>(Arrays.asList(trainingRelationTypes));
        this.sourceExtractors = Lists.newArrayList();
        this.targetExtractors = Lists.newArrayList();
        this.betweenExtractors = Lists.newArrayList();
    }

    protected void setSourceExtractors(List<FeatureExtractor1<SOURCE>> extractors) {
        this.sourceExtractors = new ArrayList<FeatureExtractor1<SOURCE>>();
        for (FeatureExtractor1<SOURCE> extractor : extractors) {
            this.sourceExtractors.add((FeatureExtractor1<SOURCE>)new NamingExtractor1("Source", extractor));
        }
    }

    protected void setTargetExtractors(List<FeatureExtractor1<TARGET>> extractors) {
        this.targetExtractors = new ArrayList<FeatureExtractor1<TARGET>>();
        for (FeatureExtractor1<TARGET> extractor : extractors) {
            this.targetExtractors.add((FeatureExtractor1<TARGET>)new NamingExtractor1("Target", extractor));
        }
    }

    protected void setBetweenExtractors(List<FeatureExtractor2<Anchor, Anchor>> extractors) {
        this.betweenExtractors = extractors;
    }

    protected abstract List<SourceTargetPair> getSourceTargetPairs(JCas var1);

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        HashBasedTable links = HashBasedTable.create();
        for (TemporalLink temporalLink : JCasUtil.select((JCas)jCas, TemporalLink.class)) {
            Object target;
            Anchor source;
            Anchor sourceAnchor = temporalLink.getSource();
            Anchor targetAnchor = temporalLink.getTarget();
            if (this.sourceClass.isInstance(sourceAnchor) && this.targetClass.isInstance(targetAnchor)) {
                source = (Anchor)this.sourceClass.cast(sourceAnchor);
                target = (Anchor)this.targetClass.cast(targetAnchor);
                String string = temporalLink.getRelationType();
                links.put((Object)source, target, (Object)string);
            }
            if (!this.sourceClass.isInstance(targetAnchor) || !this.targetClass.isInstance(sourceAnchor)) continue;
            source = (Anchor)this.sourceClass.cast(targetAnchor);
            target = (Anchor)this.targetClass.cast(sourceAnchor);
            String string = REVERSE_RELATION.get(temporalLink.getRelationType());
            if (string == null) {
                throw new UnsupportedOperationException("Unknown relation: " + temporalLink.getRelationType());
            }
            links.put((Object)source, target, (Object)string);
        }
        for (SourceTargetPair sourceTargetPair : this.getSourceTargetPairs(jCas)) {
            String relation;
            Object source = sourceTargetPair.source;
            Object target = sourceTargetPair.target;
            ArrayList features = new ArrayList();
            for (FeatureExtractor1<SOURCE> featureExtractor1 : this.sourceExtractors) {
                features.addAll(featureExtractor1.extract(jCas, source));
            }
            for (FeatureExtractor1 featureExtractor1 : this.targetExtractors) {
                features.addAll(featureExtractor1.extract(jCas, (Annotation)target));
            }
            for (FeatureExtractor2 featureExtractor2 : this.betweenExtractors) {
                features.addAll(featureExtractor2.extract(jCas, source, (Annotation)target));
            }
            if (this.isTraining()) {
                relation = (String)links.remove(source, target);
                if (relation == null) continue;
                if (!this.trainingRelationTypes.isEmpty() && !this.trainingRelationTypes.contains(relation)) {
                    relation = NO_RELATION;
                }
                this.dataWriter.write(new Instance((Object)relation, features));
                continue;
            }
            relation = (String)this.classifier.classify(features);
            if (NO_RELATION.equals(relation)) continue;
            int n = jCas.getDocumentText().length();
            TemporalLink tlink = new TemporalLink(jCas, n, n);
            tlink.setSource(source);
            tlink.setTarget((Anchor)target);
            tlink.setRelationType(relation);
            tlink.addToIndexes();
        }
        if (!links.isEmpty()) {
            HashMap<Anchor, Sentence> sentences = new HashMap<Anchor, Sentence>();
            for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
                for (Anchor source : JCasUtil.selectCovered((JCas)jCas, this.sourceClass, (AnnotationFS)sentence)) {
                    sentences.put(source, sentence);
                }
                for (Anchor target : JCasUtil.selectCovered((JCas)jCas, this.targetClass, (AnnotationFS)sentence)) {
                    sentences.put(target, sentence);
                }
            }
            ArrayList arrayList = Lists.newArrayList((Iterable)links.cellSet());
            Ordering order = Ordering.natural().onResultOf(new Function<Table.Cell<SOURCE, TARGET, String>, Integer>(){

                public Integer apply(Table.Cell<SOURCE, TARGET, String> cell) {
                    return ((Anchor)cell.getRowKey()).getBegin();
                }
            });
            Collections.sort(arrayList, order);
            StringBuilder errorBuilder = new StringBuilder();
            errorBuilder.append("Missed ").append(links.size()).append(" TLINK(s)\n");
            for (Table.Cell cell : arrayList) {
                Anchor anchor = (Anchor)cell.getRowKey();
                Anchor target = (Anchor)cell.getColumnKey();
                String relation = (String)cell.getValue();
                Sentence sent1 = (Sentence)sentences.get(anchor);
                Sentence sent2 = (Sentence)sentences.get(target);
                errorBuilder.append(String.format("%s(%s, %s)\n%s\n%s\n", relation, anchor.getCoveredText(), target.getCoveredText(), sent1 == null ? null : sent1.getCoveredText(), sent2 == null ? null : sent2.getCoveredText()));
            }
            this.getContext().getLogger().log(Level.FINE, errorBuilder.toString());
        }
    }

    protected static String noLeavesPath(TreebankNodeUtil.TreebankNodePath path) {
        if (path.getCommonAncestor() == null) {
            return null;
        }
        ArrayList<String> sourceTypes = new ArrayList<String>();
        for (Object node : path.getSourceToAncestorPath()) {
            if (node.getLeaf()) continue;
            sourceTypes.add(node.getNodeType());
        }
        ArrayList<String> targetTypes = new ArrayList<String>();
        for (TreebankNode node : path.getTargetToAncestorPath()) {
            if (node.getLeaf()) continue;
            targetTypes.add(node.getNodeType());
        }
        Collections.reverse(targetTypes);
        StringBuilder builder = new StringBuilder();
        for (String type : sourceTypes) {
            builder.append(type).append('>');
        }
        builder.append(path.getCommonAncestor().getNodeType());
        for (String type : targetTypes) {
            builder.append('<').append(type);
        }
        return builder.toString();
    }

    static {
        REVERSE_RELATION.put("BEFORE", "AFTER");
        REVERSE_RELATION.put("AFTER", "BEFORE");
        REVERSE_RELATION.put("INCLUDES", "IS_INCLUDED");
        REVERSE_RELATION.put("IS_INCLUDED", "INCLUDES");
        REVERSE_RELATION.put("DURING", "DURING_INV");
        REVERSE_RELATION.put("DURING_INV", "DURING");
        REVERSE_RELATION.put("SIMULTANEOUS", "SIMULTANEOUS");
        REVERSE_RELATION.put("IAFTER", "IBEFORE");
        REVERSE_RELATION.put("IBEFORE", "IAFTER");
        REVERSE_RELATION.put("IDENTITY", "IDENTITY");
        REVERSE_RELATION.put("BEGINS", "BEGUN_BY");
        REVERSE_RELATION.put("ENDS", "ENDED_BY");
        REVERSE_RELATION.put("BEGUN_BY", "BEGINS");
        REVERSE_RELATION.put("ENDED_BY", "ENDS");
        REVERSE_RELATION.put("OVERLAP", "OVERLAP");
        REVERSE_RELATION.put("OVERLAP-OR-AFTER", "BEFORE-OR-OVERLAP");
        REVERSE_RELATION.put("BEFORE-OR-OVERLAP", "OVERLAP-OR-AFTER");
        REVERSE_RELATION.put("VAGUE", "VAGUE");
        REVERSE_RELATION.put("UNKNOWN", "UNKNOWN");
        REVERSE_RELATION.put("NONE", "NONE");
    }

    protected static class SourceTargetPair {
        public SOURCE source;
        public TARGET target;
        final /* synthetic */ TemporalLinkAnnotator_ImplBase this$0;

        public SourceTargetPair(SOURCE source, TARGET target) {
            this.this$0 = this$0;
            this.source = source;
            this.target = target;
        }
    }
}

