/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.tlink;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.cleartk.feature.syntax.TargetPathExtractor;
import org.cleartk.feature.token.TokenTextForSelectedPosExtractor;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.NamingExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;
import org.cleartk.ml.liblinear.LibLinearStringOutcomeDataWriter;
import org.cleartk.syntax.constituent.type.TopTreebankNode;
import org.cleartk.syntax.constituent.type.TreebankNode;
import org.cleartk.timeml.type.Anchor;
import org.cleartk.timeml.type.Event;
import org.cleartk.timeml.type.TemporalLink;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.cleartk.token.type.Sentence;
import org.cleartk.token.type.Token;
import org.cleartk.util.AnnotationUtil;

@TypeCapability(outputs={"org.cleartk.timeml.type.TemporalLink", "org.cleartk.timeml.type.Event"})
public class VerbClauseTemporalAnnotator
extends CleartkAnnotator<String> {
    public static final CleartkInternalModelFactory FACTORY = new CleartkInternalModelFactory(){

        @Override
        public Class<?> getAnnotatorClass() {
            return VerbClauseTemporalAnnotator.class;
        }

        @Override
        public Class<?> getDataWriterClass() {
            return LibLinearStringOutcomeDataWriter.class;
        }

        @Override
        public AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createEngineDescription(VerbClauseTemporalAnnotator.class, (Object[])new Object[0]);
        }
    };
    private static final Map<String, String[]> headMap = new HashMap<String, String[]>();
    private static final Set<String> stopWords;
    private List<FeatureExtractor1<Token>> sourceFeatureExtractors;
    private List<FeatureExtractor1<Token>> targetFeatureExtractors;
    private List<FeatureExtractor1<Annotation>> betweenAnchorsFeatureExtractors;
    private TargetPathExtractor pathExtractor;
    private int eventID = 1;
    @ConfigurationParameter(name="createEvents", defaultValue={"false"}, description="Create events for all verbs in verb-clause relations (using existing events if present, but adding new ones wherever they are not present).")
    private boolean createEvents;
    public static final String PARAM_CREATE_EVENTS = "createEvents";

    public VerbClauseTemporalAnnotator() {
        CleartkExtractor precedingAuxiliaries = new CleartkExtractor(Token.class, (FeatureExtractor1)new TokenTextForSelectedPosExtractor(new String[]{"MD", "TO", "IN", "VB", "RB"}), new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(3)});
        TypePathExtractor tokenStemExtractor = new TypePathExtractor(Token.class, "stem");
        TypePathExtractor tokenPOSExtractor = new TypePathExtractor(Token.class, "pos");
        this.sourceFeatureExtractors = Lists.newArrayList();
        this.sourceFeatureExtractors.add((FeatureExtractor1<Token>)new NamingExtractor1("Source", (FeatureExtractor1)new CoveredTextExtractor()));
        this.sourceFeatureExtractors.add((FeatureExtractor1<Token>)new NamingExtractor1("Source", (FeatureExtractor1)tokenPOSExtractor));
        this.sourceFeatureExtractors.add((FeatureExtractor1<Token>)new NamingExtractor1("Source", (FeatureExtractor1)tokenStemExtractor));
        this.sourceFeatureExtractors.add((FeatureExtractor1<Token>)new NamingExtractor1("Source", (FeatureExtractor1)precedingAuxiliaries));
        this.targetFeatureExtractors = Lists.newArrayList();
        this.targetFeatureExtractors.add((FeatureExtractor1<Token>)new NamingExtractor1("Target", (FeatureExtractor1)new CoveredTextExtractor()));
        this.targetFeatureExtractors.add((FeatureExtractor1<Token>)new NamingExtractor1("Target", (FeatureExtractor1)tokenPOSExtractor));
        this.targetFeatureExtractors.add((FeatureExtractor1<Token>)new NamingExtractor1("Target", (FeatureExtractor1)tokenStemExtractor));
        this.targetFeatureExtractors.add((FeatureExtractor1<Token>)new NamingExtractor1("Target", (FeatureExtractor1)precedingAuxiliaries));
        this.betweenAnchorsFeatureExtractors = new ArrayList<FeatureExtractor1<Annotation>>();
        this.betweenAnchorsFeatureExtractors.add((FeatureExtractor1<Annotation>)new NamingExtractor1("WordsBetween", (FeatureExtractor1)new CleartkExtractor(Token.class, (FeatureExtractor1)new CoveredTextExtractor(), new CleartkExtractor.Context[]{new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()})})));
        this.pathExtractor = new TargetPathExtractor();
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        int docEnd = jCas.getDocumentText().length();
        Map<String, TemporalLink> tlinks = null;
        if (this.isTraining()) {
            tlinks = this.getTemporalLinks(jCas);
        }
        for (Sentence sentence : JCasUtil.select((JCas)jCas, Sentence.class)) {
            TopTreebankNode tree = (TopTreebankNode)AnnotationUtil.selectFirstMatching((JCas)jCas, TopTreebankNode.class, (Annotation)sentence);
            if (tree == null) {
                String fmt = "missing syntactic parse for sentence: %s";
                String msg = String.format(fmt, sentence.getCoveredText());
                this.getContext().getLogger().log(Level.WARNING, msg);
                continue;
            }
            ArrayList<TreebankNodeLink> links = new ArrayList<TreebankNodeLink>();
            this.collectVerbClausePairs((TreebankNode)tree, links);
            for (TreebankNodeLink link : links) {
                TemporalLink tlink;
                Token sourceToken = (Token)JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)link.source).get(0);
                Token targetToken = (Token)JCasUtil.selectCovered((JCas)jCas, Token.class, (AnnotationFS)link.target).get(0);
                int firstEnd = Math.min(sourceToken.getEnd(), targetToken.getEnd());
                int lastBegin = Math.max(sourceToken.getBegin(), targetToken.getBegin());
                Instance instance = new Instance();
                for (FeatureExtractor1<Token> featureExtractor1 : this.sourceFeatureExtractors) {
                    instance.addAll((Collection)featureExtractor1.extract(jCas, (Annotation)sourceToken));
                }
                for (FeatureExtractor1<Token> featureExtractor1 : this.targetFeatureExtractors) {
                    instance.addAll((Collection)featureExtractor1.extract(jCas, (Annotation)targetToken));
                }
                Annotation windowAnnotation = new Annotation(jCas, firstEnd, lastBegin);
                for (FeatureExtractor1<Annotation> extractor3 : this.betweenAnchorsFeatureExtractors) {
                    instance.addAll((Collection)extractor3.extract(jCas, windowAnnotation));
                }
                instance.addAll((Collection)this.pathExtractor.extract(jCas, link.source, link.target));
                Anchor anchor = (Anchor)AnnotationUtil.selectFirstMatching((JCas)jCas, Anchor.class, (Annotation)link.source);
                Anchor target = (Anchor)AnnotationUtil.selectFirstMatching((JCas)jCas, Anchor.class, (Annotation)link.target);
                if (this.isTraining()) {
                    String key;
                    if (anchor == null || target == null || (tlink = tlinks.remove(key = String.format("%s:%s", anchor.getId(), target.getId()))) == null) continue;
                    instance.setOutcome((Object)tlink.getRelationType());
                    this.dataWriter.write(instance);
                    continue;
                }
                Event event = this.getOrCreateEvent(jCas, anchor, link.source);
                target = this.getOrCreateEvent(jCas, target, link.target);
                if (event == null || target == null) continue;
                String relationType = (String)this.classifier.classify(instance.getFeatures());
                tlink = new TemporalLink(jCas, docEnd, docEnd);
                tlink.setSource((Anchor)event);
                tlink.setTarget(target);
                tlink.setRelationType(relationType);
                tlink.addToIndexes();
            }
        }
    }

    private Event getOrCreateEvent(JCas jCas, Anchor anchor, TreebankNode node) {
        if (anchor != null && anchor instanceof Event) {
            return (Event)anchor;
        }
        if (this.createEvents) {
            Event event = new Event(jCas, node.getBegin(), node.getEnd());
            event.setId("e" + this.eventID);
            ++this.eventID;
            event.addToIndexes();
            return event;
        }
        return null;
    }

    private Map<String, TemporalLink> getTemporalLinks(JCas jCas) {
        HashMap<String, TemporalLink> tlinks = new HashMap<String, TemporalLink>();
        for (TemporalLink tlink : JCasUtil.select((JCas)jCas, TemporalLink.class)) {
            String sourceID = tlink.getSource().getId();
            String targetID = tlink.getTarget().getId();
            String key = String.format("%s:%s", sourceID, targetID);
            tlinks.put(key, tlink);
        }
        return tlinks;
    }

    private void collectVerbClausePairs(TreebankNode node, List<TreebankNodeLink> links) {
        if (this.isVerbPhrase(node)) {
            ArrayList<TreebankNode> sources = new ArrayList<TreebankNode>();
            ArrayList<TreebankNode> targets = new ArrayList<TreebankNode>();
            this.collectHeads(node, sources);
            for (int i = 0; i < node.getChildren().size(); ++i) {
                TreebankNode child = node.getChildren(i);
                if (!this.isClause(child)) continue;
                targets.clear();
                this.collectHeads(child, targets);
                for (TreebankNode source : sources) {
                    for (TreebankNode target : targets) {
                        if (this.contains(child, source)) continue;
                        links.add(new TreebankNodeLink(source, target));
                    }
                }
            }
        }
        for (int i = 0; i < node.getChildren().size(); ++i) {
            TreebankNode child = node.getChildren(i);
            this.collectVerbClausePairs(child, links);
        }
    }

    private void collectHeads(TreebankNode node, List<TreebankNode> heads) {
        String[] headTypes;
        if (node.getLeaf()) {
            heads.add(node);
        }
        if ((headTypes = headMap.get(node.getNodeType())) != null) {
            for (String headType : headTypes) {
                boolean foundChildWithHeadType = false;
                for (int i = 0; i < node.getChildren().size(); ++i) {
                    String text;
                    TreebankNode child = node.getChildren(i);
                    if (!child.getNodeType().equals(headType) || stopWords.contains(text = child.getCoveredText())) continue;
                    this.collectHeads(child, heads);
                    foundChildWithHeadType = true;
                }
                if (foundChildWithHeadType) break;
            }
        }
    }

    private boolean contains(TreebankNode node, TreebankNode descendant) {
        if (node == descendant) {
            return true;
        }
        for (int i = 0; i < node.getChildren().size(); ++i) {
            boolean result = this.contains(node.getChildren(i), descendant);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private boolean isVerbPhrase(TreebankNode node) {
        return node.getNodeType().startsWith("VP");
    }

    private boolean isClause(TreebankNode node) {
        return node.getNodeType().startsWith("S");
    }

    static {
        headMap.put("S", "VP S SBAR ADJP".split(" "));
        headMap.put("SBAR", "VP S SBAR ADJP".split(" "));
        headMap.put("VP", "VP VB VBZ VBP VBG VBN VBD JJ JJR JJS NNS NN PRP NNPS NNP ADJP NP S SBAR".split(" "));
        headMap.put("ADJP", "ADJP VB VBZ VBP VBG VBN VBD JJ JJR JJS".split(" "));
        headMap.put("NP", "NP NNS NN PRP NNPS NNP QP ADJP".split(" "));
        headMap.put("QP", "NP NNS NN PRP NNPS NNP QP ADJP".split(" "));
        stopWords = new HashSet<String>(Arrays.asList("be been is 's am are was were has had have".split(" ")));
    }

    private class TreebankNodeLink {
        public TreebankNode source;
        public TreebankNode target;

        public TreebankNodeLink(TreebankNode source, TreebankNode target) {
            this.source = source;
            this.target = target;
        }
    }
}

