/*
 * Decompiled with CFR 0.152.
 */
package org.codedoers.maven;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketCaller {
    private static final Logger log = LoggerFactory.getLogger(BitbucketCaller.class);
    private static Gson gson = new Gson();
    private final Executor executor;

    public BitbucketCaller(String user, String password) {
        this.executor = Executor.newInstance().auth(new HttpHost("api.bitbucket.org", 443, "https"), user, password).authPreemptive(new HttpHost("api.bitbucket.org", 443, "https"));
    }

    public CastableWrapper page(String url) {
        try {
            return this.asCastable(this.executor.execute(Request.Get((String)url)).returnContent());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private CastableWrapper asCastable(Content content) {
        return new CastableWrapper(content);
    }

    public void upload(File file, String url, String fileName) throws IOException {
        HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody("files", file, ContentType.MULTIPART_FORM_DATA, fileName).build();
        Request request = Request.Post((String)url).body(entity);
        this.executor.execute(request).discardContent();
    }

    public void download(File file, String url) throws IOException {
        Response response = this.executor.execute(Request.Get((String)url));
        response.saveContent(file);
    }

    public static class CastableWrapper {
        public final Content content;

        public CastableWrapper(Content content) {
            this.content = content;
        }

        public Content getContent() {
            return this.content;
        }

        public <T> T as(Class<T> cl) {
            return (T)gson.fromJson((Reader)new InputStreamReader(this.content.asStream()), cl);
        }
    }
}

