/*
 * Copyright 2018 Codedoers.com.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codedoers.maven.bitbucket;

import java.util.ArrayList;
import java.util.Collection;
import org.codedoers.maven.BitbucketCaller;
import org.codedoers.maven.PageableIterator;

public class Page<W> {

	private int pagelen;
	private int size;
	private Collection<W> values = new ArrayList<>();
	private int page;
	private String next;

	public int getPagelen() {
		return pagelen;
	}

	public int getSize() {
		return size;
	}

	public Collection<W> getValues() {
		return values;
	}

	public int getPage() {
		return page;
	}

	public String getNext() {
		return next;
	}

	public PageableIterator<W> iterator(BitbucketCaller caller) {
		return PageableIterator.<W>create(caller, this, (Class<Page<W>>) this.getClass());
	}

}
