/*
 * Decompiled with CFR 0.152.
 */
package org.codedoers.maven.bitbucket;

import java.util.regex.Matcher;
import org.codedoers.maven.BitbucketAPI;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketURLFactory {
    private static final Logger log = LoggerFactory.getLogger(BitbucketURLFactory.class);
    private final String team;
    private final String repository;

    public BitbucketURLFactory(String mvnRepositoryURL) {
        Matcher matcher = BitbucketAPI.EXTRACTION_PATTERN.matcher(mvnRepositoryURL);
        this.assertTeamFound(matcher);
        this.team = matcher.group(1);
        this.repository = matcher.group(2);
    }

    public String repositories() {
        return "https://api.bitbucket.org/2.0/repositories/" + this.team;
    }

    public String downloads() {
        return this.downloads(this.repository);
    }

    public String downloads(String repositorySLUG) {
        return "https://api.bitbucket.org/2.0/repositories/" + this.team + "/" + repositorySLUG + "/downloads/";
    }

    public String download(String fileName) {
        return this.download(this.repository);
    }

    public String download(String repositorySLUG, String fileName) {
        return this.downloads(repositorySLUG) + fileName;
    }

    public String upload() {
        return this.upload(this.repository);
    }

    private String upload(String repositorySLUG) {
        return "https://api.bitbucket.org/2.0/repositories/" + this.team + "/" + repositorySLUG + "/downloads";
    }

    private void assertTeamFound(Matcher matcher) {
        if (!matcher.find()) {
            log.error("Match for team failed from");
            throw new RuntimeException("Match for team failed from");
        }
    }

    public boolean withRepository() {
        return StringUtils.isNotBlank((String)this.repository);
    }
}

