/*
 * Decompiled with CFR 0.152.
 */
package org.codedoers.maven;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.codedoers.maven.BitbucketCaller;
import org.codedoers.maven.PageableIterator;
import org.codedoers.maven.bitbucket.BitbucketURLFactory;
import org.codedoers.maven.bitbucket.DownloadItem;
import org.codedoers.maven.bitbucket.Repository;
import org.codedoers.maven.bitbucket.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketDownloadWagon
extends AbstractWagon {
    private static final Logger log = LoggerFactory.getLogger(BitbucketDownloadWagon.class);
    private String url;
    private BitbucketCaller bitbucket;
    private BitbucketURLFactory urlFactory;
    private Collection<Repository> repositories;
    private List<DownloadItem> downloadItems;

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        if (this.getRepository().getUrl().equals(this.url)) {
            log.info("Already cached");
            return;
        }
        this.url = this.getRepository().getUrl();
        this.urlFactory = new BitbucketURLFactory(this.getRepository().getUrl());
        this.bitbucket = new BitbucketCaller(this.getAuthenticationInfo().getUserName(), this.getAuthenticationInfo().getPassword());
        if (!this.urlFactory.withRepository()) {
            this.fetchRepositories();
            this.downloadItems = this.streamFromAllRepositories().collect(Collectors.toList());
            log.info("Cached {} repositories and {} download items in total", (Object)this.repositories.size(), (Object)this.downloadItems.size());
        }
    }

    public void closeConnection() throws ConnectionException {
        log.info("Closing bitbucket repositories, nothing to do here...");
    }

    private void fetchRepositories() throws ConnectionException {
        log.info("Fetching repositories for - {}", (Object)this.getRepository().getUrl());
        this.repositories = this.bitbucket.page(this.urlFactory.repositories()).as(Repository.Page.class).iterator(this.bitbucket).stream().collect(Collectors.toList());
    }

    public void get(String filename, File file) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        log.info("Fetching {} to file {}", (Object)filename, (Object)file.getPath());
        String name = this.normalizeFileName(filename);
        this.filterStreamAndDownload(this.streamDownloadItems(), name, file);
    }

    private Stream<DownloadItem> streamDownloadItems() {
        if (this.urlFactory.withRepository()) {
            return this.streamFromDefaultRepository();
        }
        return this.downloadItems.stream();
    }

    private Stream<DownloadItem> streamFromAllRepositories() {
        return this.repositories.stream().map(Repository::getDownloads).map(Self::getHref).map(this.bitbucket::page).map(c -> c.as(DownloadItem.Page.class)).map(i -> i.iterator(this.bitbucket)).flatMap(PageableIterator::stream);
    }

    private Stream<DownloadItem> streamFromDefaultRepository() {
        return this.bitbucket.page(this.urlFactory.downloads()).as(DownloadItem.Page.class).iterator(this.bitbucket).stream();
    }

    private void filterStreamAndDownload(Stream<DownloadItem> stream, String name, File file) throws TransferFailedException, ResourceDoesNotExistException {
        Optional<String> found = this.findByName(stream, name);
        try {
            this.bitbucket.download(file, found.orElseThrow(() -> new ResourceDoesNotExistException(name + " not found")));
        }
        catch (IOException ex) {
            throw new TransferFailedException("Bitbucket error", (Throwable)ex);
        }
    }

    private Optional<String> findByName(Stream<DownloadItem> stream, String name) {
        Optional<String> found = stream.filter(di -> name.equals(di.getName())).map(DownloadItem::getLinks).map(DownloadItem.Links::getSelf).map(Self::getHref).findAny();
        return found;
    }

    public boolean getIfNewer(String filename, File file, long l) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.get(filename, file);
        return true;
    }

    public void put(File file, String filename) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        log.info("Deploying {} as {}", (Object)file.getAbsolutePath(), (Object)filename);
        try {
            this.bitbucket.upload(file, this.urlFactory.upload(), this.normalizeFileName(filename));
        }
        catch (IOException ex) {
            throw new TransferFailedException("Bitbucket error", (Throwable)ex);
        }
    }

    private String normalizeFileName(String name) {
        return name.replace("/", "-");
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        String name = this.normalizeFileName(resourceName);
        return this.filterStreamAndCheckExists(this.streamDownloadItems(), name);
    }

    private boolean filterStreamAndCheckExists(Stream<DownloadItem> streamDownloadItems, String name) {
        return this.findByName(streamDownloadItems, name).isPresent();
    }
}

