/*
 * Decompiled with CFR 0.152.
 */
package org.codedoers.maven;

import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.codedoers.maven.BitbucketCaller;
import org.codedoers.maven.bitbucket.Page;
import org.codehaus.plexus.util.StringUtils;

public class PageableIterator<T>
implements Iterator<T> {
    private final BitbucketCaller bitbucket;
    private final Function<BitbucketCaller.CastableWrapper, Page<T>> caster;
    private Page<T> page;
    private Iterator<T> iterator;

    public static <T> PageableIterator<T> create(BitbucketCaller bitbucket, Page<T> initial, Class<Page<T>> cl) {
        return new PageableIterator<T>(bitbucket, initial, c -> (Page)c.as(cl));
    }

    public PageableIterator(BitbucketCaller bitbucket, Page<T> initial, Function<BitbucketCaller.CastableWrapper, Page<T>> caster) {
        this.bitbucket = bitbucket;
        this.caster = caster;
        this.page = initial;
        this.iterator = this.page.getValues().iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator.hasNext()) {
            return true;
        }
        if (StringUtils.isNotBlank((String)this.page.getNext())) {
            this.page = this.caster.apply(this.bitbucket.nextPage(this.page.getNext()));
            this.iterator = this.page.getValues().iterator();
            return this.hasNext();
        }
        return false;
    }

    @Override
    public T next() {
        return this.iterator.next();
    }

    public Stream<T> stream() {
        Iterable iterable = () -> this;
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

