/*
 * Decompiled with CFR 0.152.
 */
package org.codedoers.maven;

import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketCaller {
    private static final Logger log = LoggerFactory.getLogger(BitbucketCaller.class);
    private static final Set<Integer> OK_RESPONSES = Stream.of(200, 201, 202).collect(Collectors.toSet());
    private static final Set<Integer> AUTH_NOTOK_RESPONSES = Stream.of(401, 403, 405).collect(Collectors.toSet());
    private static final Set<Integer> RESOURCE_NOTOK_RESPONSES = Stream.of(Integer.valueOf(404)).collect(Collectors.toSet());
    private static Gson gson = new Gson();
    private final Executor executor;

    public BitbucketCaller(String user, String password) {
        this.executor = Executor.newInstance().auth(new HttpHost("api.bitbucket.org", 443, "https"), user, password).authPreemptive(new HttpHost("api.bitbucket.org", 443, "https"));
    }

    public CastableWrapper page(String url) {
        url = url + "?pagelen=100";
        return this.internalPage(url);
    }

    private CastableWrapper internalPage(String url) {
        log.debug("Trying page for {}", (Object)url);
        try {
            return this.asCastable(this.executor.execute(Request.Get((String)url)).returnContent());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public CastableWrapper nextPage(String url) {
        return this.internalPage(url);
    }

    private CastableWrapper asCastable(Content content) {
        return new CastableWrapper(content);
    }

    public void upload(File file, String url, String fileName) throws IOException, AuthorizationException, ResourceDoesNotExistException, TransferFailedException {
        HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody("files", file, ContentType.MULTIPART_FORM_DATA, fileName).build();
        Request request = Request.Post((String)url).body(entity);
        HttpResponse response = this.executor.execute(request).returnResponse();
        this.handle(response);
    }

    public void download(File file, String url) throws IOException {
        Response response = this.executor.execute(Request.Get((String)url));
        response.saveContent(file);
    }

    private void handle(HttpResponse response) throws AuthorizationException, ResourceDoesNotExistException, TransferFailedException {
        int status = response.getStatusLine().getStatusCode();
        if (OK_RESPONSES.contains(status)) {
            return;
        }
        if (AUTH_NOTOK_RESPONSES.contains(status)) {
            throw new AuthorizationException(response.getStatusLine().getReasonPhrase());
        }
        if (RESOURCE_NOTOK_RESPONSES.contains(status)) {
            throw new ResourceDoesNotExistException(response.getStatusLine().getReasonPhrase());
        }
        throw new TransferFailedException(response.getStatusLine().getReasonPhrase());
    }

    public static class CastableWrapper {
        public final Content content;

        public CastableWrapper(Content content) {
            this.content = content;
        }

        public Content getContent() {
            return this.content;
        }

        public <T> T as(Class<T> cl) {
            return (T)gson.fromJson((Reader)new InputStreamReader(this.content.asStream()), cl);
        }
    }
}

