/*
 * Decompiled with CFR 0.152.
 */
package org.codedoers.maven;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.codedoers.maven.BitbucketCaller;
import org.codedoers.maven.PageableIterator;
import org.codedoers.maven.bitbucket.BitbucketURLFactory;
import org.codedoers.maven.bitbucket.DownloadItem;
import org.codedoers.maven.bitbucket.Repository;
import org.codedoers.maven.bitbucket.Self;
import org.codedoers.maven.bitbucket.StaticCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketDownloadWagon
extends AbstractWagon {
    private static final Logger log = LoggerFactory.getLogger(BitbucketDownloadWagon.class);
    private static final StaticCache STATIC_CACHE = new StaticCache();
    private String url;
    private BitbucketCaller bitbucket;
    private BitbucketURLFactory urlFactory;
    private StaticCache.CacheElement currentCachedElement;

    protected void openConnectionInternal() {
        if (this.getRepository().getUrl().equals(this.url)) {
            log.info("Already cached");
            return;
        }
        this.url = this.getRepository().getUrl();
        this.urlFactory = new BitbucketURLFactory(this.getRepository().getUrl());
        this.bitbucket = new BitbucketCaller(this.getAuthenticationInfo().getUserName(), this.getAuthenticationInfo().getPassword());
        if (!this.urlFactory.withRepository()) {
            this.currentCachedElement = STATIC_CACHE.getFromCacheOrFetch(this.url, this::fetchRepositories, this::fetchAllDownloadItems);
        }
    }

    public void closeConnection() {
        log.info("Closing bitbucket repositories, nothing to do here...");
    }

    private Collection<Repository> fetchRepositories() {
        log.info("Fetching repositories from Bitbucket for - {}", (Object)this.url);
        return this.bitbucket.page(this.urlFactory.repositories(), Repository.FIELDS).as(Repository.Page.class).iterator(this.bitbucket).stream().collect(Collectors.toList());
    }

    public void get(String filename, File file) throws TransferFailedException, ResourceDoesNotExistException {
        log.info("Fetching {} to file {}", (Object)filename, (Object)file.getPath());
        String name = this.normalizeFileName(filename);
        this.filterStreamAndDownload(this.streamDownloadItems(), name, file);
    }

    private Stream<DownloadItem> streamDownloadItems() {
        if (this.urlFactory.withRepository()) {
            return this.streamFromDefaultRepository();
        }
        return this.currentCachedElement.getDownloadItems().stream();
    }

    private List<DownloadItem> fetchAllDownloadItems(Collection<Repository> repositories) {
        return repositories.stream().map(Repository::getDownloads).map(Self::getHref).map(href -> this.bitbucket.page((String)href, "pagelen,size,next,page,values.name,values.links.self")).map(c -> c.as(DownloadItem.Page.class)).map(i -> i.iterator(this.bitbucket)).flatMap(PageableIterator::stream).collect(Collectors.toList());
    }

    private Stream<DownloadItem> streamFromDefaultRepository() {
        return this.bitbucket.page(this.urlFactory.downloads(), "pagelen,size,next,page,values.name,values.links.self").as(DownloadItem.Page.class).iterator(this.bitbucket).stream();
    }

    private void filterStreamAndDownload(Stream<DownloadItem> stream, String name, File file) throws TransferFailedException {
        Optional<String> found = this.findByName(stream, name);
        try {
            this.bitbucket.download(file, found.orElseThrow(() -> new ResourceDoesNotExistException(name + " not found")));
        }
        catch (Throwable ex) {
            log.error("Error download file " + name, ex);
            throw new TransferFailedException("Bitbucket error", ex);
        }
    }

    private Optional<String> findByName(Stream<DownloadItem> stream, String name) {
        Optional<String> found = stream.filter(di -> name.equals(di.getName())).map(DownloadItem::getLinks).map(DownloadItem.Links::getSelf).map(Self::getHref).findAny();
        return found;
    }

    public boolean getIfNewer(String filename, File file, long l) throws TransferFailedException, ResourceDoesNotExistException {
        this.get(filename, file);
        return true;
    }

    public void put(File file, String filename) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        log.info("Deploying {} as {}", (Object)file.getAbsolutePath(), (Object)filename);
        try {
            this.bitbucket.upload(file, this.urlFactory.upload(), this.normalizeFileName(filename));
        }
        catch (IOException ex) {
            throw new TransferFailedException("Bitbucket error", (Throwable)ex);
        }
    }

    private String normalizeFileName(String name) {
        return name.replace("/", "-");
    }

    public boolean resourceExists(String resourceName) {
        String name = this.normalizeFileName(resourceName);
        return this.filterStreamAndCheckExists(this.streamDownloadItems(), name);
    }

    private boolean filterStreamAndCheckExists(Stream<DownloadItem> streamDownloadItems, String name) {
        return this.findByName(streamDownloadItems, name).isPresent();
    }
}

