/*
 * Decompiled with CFR 0.152.
 */
package org.codedoers.maven.bitbucket;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codedoers.maven.bitbucket.DownloadItem;
import org.codedoers.maven.bitbucket.Repository;

public class StaticCache {
    private Map<String, CacheElement> cache = new HashMap<String, CacheElement>();

    public synchronized CacheElement getFromCacheOrFetch(String url, Supplier<Collection<Repository>> fetchRepositories, Function<Collection<Repository>, List<DownloadItem>> fetchAllDownloadItems) {
        return this.cache.computeIfAbsent(url, this.createFetcher(fetchRepositories, fetchAllDownloadItems));
    }

    private Function<String, CacheElement> createFetcher(Supplier<Collection<Repository>> fetchRepositories, Function<Collection<Repository>, List<DownloadItem>> fetchAllDownloadItems) {
        return url -> {
            Collection repos = (Collection)fetchRepositories.get();
            List items = (List)fetchAllDownloadItems.apply(repos);
            return new CacheElement(repos, items);
        };
    }

    public class CacheElement {
        private final Collection<Repository> repositories;
        private final List<DownloadItem> downloadItems;

        private CacheElement(Collection<Repository> repositories, List<DownloadItem> downloadItems) {
            this.repositories = repositories;
            this.downloadItems = downloadItems;
        }

        public Collection<Repository> getRepositories() {
            return this.repositories;
        }

        public List<DownloadItem> getDownloadItems() {
            return this.downloadItems;
        }
    }
}

