/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen.keygenerator;

import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.keygenerator.SequenceKeyGeneratorFactory;
import org.castor.ddlgen.schemaobject.KeyGenerator;
import org.exolab.castor.mapping.xml.KeyGeneratorDef;
import org.exolab.castor.mapping.xml.Param;

public final class SequenceKeyGenerator
extends KeyGenerator {
    public static final String ALGORITHM_NAME = "SEQUENCE";
    private static final String PARAM_SEQUENCE = "sequence";
    private static final String PARAM_RETURNING = "returning";
    private static final String PARAM_TRIGGER = "trigger";
    private static final String PARAM_INCREMENT = "increment";
    private final SequenceKeyGeneratorFactory _factory;
    private String _sequence = "{0}_seq";
    private boolean _isReturning = false;
    private boolean _isTrigger = false;
    private int _increment = 1;

    protected SequenceKeyGenerator(SequenceKeyGeneratorFactory factory) {
        super(ALGORITHM_NAME, ALGORITHM_NAME);
        this._factory = factory;
    }

    protected SequenceKeyGenerator(SequenceKeyGeneratorFactory factory, KeyGeneratorDef definition) throws GeneratorException {
        super(ALGORITHM_NAME, definition.getAlias());
        this._factory = factory;
        Param[] params = definition.getParam();
        for (int i = 0; i < params.length; ++i) {
            String name = params[i].getName();
            String value = params[i].getValue();
            if (name == null) continue;
            if (PARAM_SEQUENCE.equalsIgnoreCase(name)) {
                this._sequence = value;
                continue;
            }
            if (PARAM_RETURNING.equalsIgnoreCase(name)) {
                this._isReturning = Boolean.valueOf(value);
                continue;
            }
            if (PARAM_TRIGGER.equalsIgnoreCase(name)) {
                this._isTrigger = Boolean.valueOf(value);
                continue;
            }
            if (!PARAM_INCREMENT.equalsIgnoreCase(name)) continue;
            try {
                this._increment = Integer.parseInt(value);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new GeneratorException("Can't parse integer" + name, nfe);
            }
        }
    }

    public String getSequence() {
        return this._sequence;
    }

    public boolean isReturning() {
        return this._isReturning;
    }

    public boolean isTrigger() {
        return this._isTrigger;
    }

    public int getIncrement() {
        return this._increment;
    }

    public String toCreateDDL() {
        return this._factory.toCreateDDL(this);
    }

    public String toDropDDL() {
        return this._factory.toDropDDL(this);
    }
}

