/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen;

import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.castor.ddlgen.DDLGenConfiguration;
import org.castor.ddlgen.Generator;
import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.KeyGeneratorRegistry;
import org.castor.ddlgen.MappingHelper;
import org.castor.ddlgen.SchemaFactory;
import org.castor.ddlgen.TypeMapper;
import org.castor.ddlgen.TypeNotFoundException;
import org.castor.ddlgen.schemaobject.Field;
import org.castor.ddlgen.schemaobject.ForeignKey;
import org.castor.ddlgen.schemaobject.Index;
import org.castor.ddlgen.schemaobject.KeyGenerator;
import org.castor.ddlgen.schemaobject.PrimaryKey;
import org.castor.ddlgen.schemaobject.Schema;
import org.castor.ddlgen.schemaobject.Table;
import org.castor.ddlgen.typeinfo.TypeInfo;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.xml.ClassChoice;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.KeyGeneratorDef;
import org.exolab.castor.mapping.xml.MapTo;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.mapping.xml.Sql;

public abstract class AbstractGenerator
implements Generator {
    private final DDLGenConfiguration _configuration;
    private KeyGeneratorRegistry _keyGenRegistry;
    private MappingHelper _mappingHelper;
    private TypeMapper _typeMapper;
    private SchemaFactory _schemaFactory;
    private Mapping _mapping;
    private Schema _schema;
    private final Map _resolveTable = new HashMap();
    private PrintStream _printer;

    protected AbstractGenerator(DDLGenConfiguration configuration) {
        this._configuration = configuration;
    }

    public final DDLGenConfiguration getConfiguration() {
        return this._configuration;
    }

    public final void setKeyGenRegistry(KeyGeneratorRegistry keyGenRegistry) {
        this._keyGenRegistry = keyGenRegistry;
    }

    protected final void setMappingHelper(MappingHelper mappingHelper) {
        this._mappingHelper = mappingHelper;
        this._mappingHelper.setTypeMapper(this._typeMapper);
    }

    public final MappingHelper getMappingHelper() {
        return this._mappingHelper;
    }

    public final void setTypeMapper(TypeMapper typeMapper) {
        this._typeMapper = typeMapper;
        this._mappingHelper.setTypeMapper(this._typeMapper);
    }

    public final TypeMapper getTypeMapper() {
        return this._typeMapper;
    }

    protected final void setSchemaFactory(SchemaFactory schemaFactory) {
        this._schemaFactory = schemaFactory;
    }

    public final SchemaFactory getSchemaFactory() {
        return this._schemaFactory;
    }

    public final void setMapping(Mapping mapping) {
        this._mapping = mapping;
        this._mappingHelper.setMapping(this._mapping);
    }

    public final Mapping getMapping() {
        return this._mapping;
    }

    public final Schema getSchema() {
        return this._schema;
    }

    public final void setPrinter(PrintStream printer) {
        this._printer = printer;
    }

    public final PrintStream getPrinter() {
        return this._printer;
    }

    public final void generateDDL() throws GeneratorException {
        this.createSchema();
        String groupBy = this._configuration.getStringValue("org.castor.ddlgen.GroupStatements", "TABLE");
        if ("TABLE".equalsIgnoreCase(groupBy)) {
            this.generateDDLGroupByTable();
        } else if ("DDLTYPE".equalsIgnoreCase(groupBy)) {
            this.generateDDLGroupByDDLType();
        } else {
            throw new GeneratorException("group ddl by do not support: " + groupBy);
        }
    }

    private void generateDDLGroupByDDLType() throws GeneratorException {
        boolean genSchema = this._configuration.getBoolValue("org.castor.ddlgen.GenerateSchema", true);
        boolean genDrop = this._configuration.getBoolValue("org.castor.ddlgen.GenerateDrop", true);
        boolean genCreate = this._configuration.getBoolValue("org.castor.ddlgen.GenerateCreate", true);
        boolean genPrimaryKey = this._configuration.getBoolValue("org.castor.ddlgen.GeneratePrimaryKey", true);
        boolean genForeignKey = this._configuration.getBoolValue("org.castor.ddlgen.GenerateForeignKey", true);
        boolean genIndex = this._configuration.getBoolValue("org.castor.ddlgen.GenerateIndex", true);
        boolean genKeyGen = this._configuration.getBoolValue("org.castor.ddlgen.GenerateKeyGenerator", true);
        this.write(this.generateHeader());
        if (genSchema) {
            this.write(this._schema.toCreateDDL());
        }
        if (genDrop) {
            this.write(this.generateDrop());
        }
        if (genCreate) {
            this.write(this.generateCreate());
        }
        if (genPrimaryKey) {
            this.write(this.generatePrimaryKey());
        }
        if (genForeignKey) {
            this.write(this.generateForeignKey());
        }
        if (genIndex) {
            this.write(this.generateIndex());
        }
        if (genKeyGen) {
            this.write(this.generateKeyGenerator());
        }
    }

    public final String generateDrop() throws GeneratorException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this._schema.getTableCount(); ++i) {
            Table table = this._schema.getTable(i);
            buff.append(table.toDropDDL());
        }
        return buff.toString();
    }

    public final String generateCreate() throws GeneratorException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this._schema.getTableCount(); ++i) {
            Table table = this._schema.getTable(i);
            buff.append(table.toCreateDDL());
        }
        return buff.toString();
    }

    public final String generatePrimaryKey() throws GeneratorException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this._schema.getTableCount(); ++i) {
            Table table = this._schema.getTable(i);
            buff.append(table.getPrimaryKey().toCreateDDL());
        }
        return buff.toString();
    }

    public final String generateForeignKey() throws GeneratorException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this._schema.getTableCount(); ++i) {
            Table table = this._schema.getTable(i);
            buff.append(this.createForeignKeyDDL(table));
        }
        return buff.toString();
    }

    public final String generateIndex() throws GeneratorException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this._schema.getTableCount(); ++i) {
            Table table = this._schema.getTable(i);
            buff.append(this.createIndex(table));
        }
        return buff.toString();
    }

    public final String generateKeyGenerator() throws GeneratorException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this._schema.getTableCount(); ++i) {
            Table table = this._schema.getTable(i);
            if (table.getKeyGenerator() == null) continue;
            table.getKeyGenerator().setTable(table);
            buff.append(table.getKeyGenerator().toCreateDDL());
        }
        return buff.toString();
    }

    private void generateDDLGroupByTable() throws GeneratorException {
        boolean genSchema = this._configuration.getBoolValue("org.castor.ddlgen.GenerateSchema", true);
        boolean genDrop = this._configuration.getBoolValue("org.castor.ddlgen.GenerateDrop", true);
        boolean genCreate = this._configuration.getBoolValue("org.castor.ddlgen.GenerateCreate", true);
        boolean genPrimaryKey = this._configuration.getBoolValue("org.castor.ddlgen.GeneratePrimaryKey", true);
        boolean genForeignKey = this._configuration.getBoolValue("org.castor.ddlgen.GenerateForeignKey", true);
        boolean genIndex = this._configuration.getBoolValue("org.castor.ddlgen.GenerateIndex", true);
        boolean genKeyGen = this._configuration.getBoolValue("org.castor.ddlgen.GenerateKeyGenerator", true);
        this.write(this.generateHeader());
        if (genSchema) {
            this.write(this._schema.toCreateDDL());
        }
        for (int i = 0; i < this._schema.getTableCount(); ++i) {
            Table table = this._schema.getTable(i);
            StringBuffer buff = new StringBuffer();
            if (genDrop) {
                buff.append(table.toDropDDL());
            }
            if (genCreate) {
                buff.append(table.toCreateDDL());
            }
            if (genPrimaryKey) {
                buff.append(table.getPrimaryKey().toCreateDDL());
            }
            if (genForeignKey) {
                buff.append(this.createForeignKeyDDL(table));
            }
            if (genIndex) {
                buff.append(this.createIndex(table));
            }
            if (genKeyGen && table.getKeyGenerator() != null) {
                table.getKeyGenerator().setTable(table);
                buff.append(table.getKeyGenerator().toCreateDDL());
            }
            this.write(buff.toString());
        }
    }

    protected final String createForeignKeyDDL(Table table) throws GeneratorException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < table.getForeignKeyCount(); ++i) {
            ForeignKey fk = table.getForeignKey(i);
            buff.append(fk.toCreateDDL());
        }
        return buff.toString();
    }

    public final String createIndex(Table table) throws GeneratorException {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < table.getIndexCount(); ++i) {
            Index index = table.getIndex(i);
            buff.append(index.toCreateDDL());
        }
        return buff.toString();
    }

    public abstract String generateHeader();

    public final void createSchema() throws GeneratorException {
        MappingRoot root = this._mapping.getRoot();
        this._schema = this._schemaFactory.createSchema();
        this._schema.setConfiguration(this._configuration);
        Enumeration ekg = root.enumerateKeyGeneratorDef();
        while (ekg.hasMoreElements()) {
            KeyGeneratorDef definition = (KeyGeneratorDef)ekg.nextElement();
            this._keyGenRegistry.createKeyGenerator(definition);
        }
        Enumeration ec = root.enumerateClassMapping();
        while (ec.hasMoreElements()) {
            ClassMapping cm = (ClassMapping)ec.nextElement();
            Table table = this.createTable(cm);
            if (table == null) continue;
            this._schema.addTable(table);
        }
        Iterator i = this._resolveTable.keySet().iterator();
        while (i.hasNext()) {
            ClassMapping cm = (ClassMapping)this._resolveTable.get(i.next());
            Table table = this.createTable(cm);
            if (table == null) continue;
            this._schema.addTable(table);
        }
    }

    private Table createTable(ClassMapping cm) throws GeneratorException {
        String tableName = cm.getMapTo().getTable();
        if (tableName == null) {
            return null;
        }
        Table table = this._schemaFactory.createTable();
        table.setName(tableName);
        table.setConfiguration(this._configuration);
        table.setSchema(this._schema);
        PrimaryKey primarykey = this._schemaFactory.createPrimaryKey();
        primarykey.setConfiguration(this._configuration);
        primarykey.setTable(table);
        primarykey.setName("pk_" + tableName);
        table.setPrimaryKey(primarykey);
        if (cm.getClassChoice() == null) {
            return table;
        }
        boolean isUseFieldIdentity = this._mappingHelper.isUseFieldIdentity(cm);
        Enumeration ef = cm.getClassChoice().enumerateFieldMapping();
        String keygenerator = cm.getKeyGenerator();
        KeyGenerator keyGen = null;
        if (keygenerator != null) {
            keyGen = this._keyGenRegistry.getKeyGenerator(keygenerator.toUpperCase());
        }
        table.setKeyGenerator(keyGen);
        while (ef.hasMoreElements()) {
            String[] sqlnames;
            FieldMapping fm = (FieldMapping)ef.nextElement();
            if (fm.getSql() == null) continue;
            boolean isFieldIdentity = fm.getIdentity();
            if (!isUseFieldIdentity) {
                isFieldIdentity = this._mappingHelper.isIdentity(cm, fm);
            }
            if (fm.getSql().getManyTable() != null) {
                this.addResolveField(fm, cm);
            }
            if ((sqlnames = fm.getSql().getName()) == null || sqlnames.length <= 0 || fm.getSql().getManyTable() != null) continue;
            String sqltype = fm.getSql().getType();
            TypeInfo typeInfo = null;
            ClassMapping cmRef = null;
            String[] refIdTypes = null;
            boolean isUseReferenceType = false;
            if (sqltype != null) {
                typeInfo = this._typeMapper.getType(sqltype);
            }
            if (typeInfo == null) {
                cmRef = this._mappingHelper.getClassMappingByName(fm.getType());
                if (cmRef == null) {
                    typeInfo = this._typeMapper.getType(fm.getType());
                    if (typeInfo == null) {
                        throw new TypeNotFoundException("can not resolve type " + fm.getType() + " in class '" + cm.getName() + "'");
                    }
                } else {
                    isUseReferenceType = true;
                    refIdTypes = this._mappingHelper.resolveTypeReferenceForIds(fm.getType());
                    if (refIdTypes.length != sqlnames.length) {
                        throw new TypeNotFoundException("number of reference table's Id differs to number of field elements '" + fm.getName() + "' of class '" + cm.getName() + "'" + refIdTypes.length + "," + sqlnames.length);
                    }
                }
            }
            for (int i = 0; i < sqlnames.length; ++i) {
                Field field = this._schemaFactory.createField();
                field.setConfiguration(this._configuration);
                if (isUseReferenceType && (typeInfo = this._typeMapper.getType(refIdTypes[i])) == null) {
                    throw new TypeNotFoundException("can not find reference type " + refIdTypes[i] + " of class " + cm.getName());
                }
                field.setName(sqlnames[i]);
                field.setTable(table);
                field.setType(typeInfo);
                field.setIdentity(isFieldIdentity);
                field.setRequired(fm.getRequired());
                field.setKeyGenerator(keyGen);
                table.addField(field);
                if (!isFieldIdentity) continue;
                primarykey.addField(field);
            }
            if (!isUseReferenceType) continue;
            this.addOneOneForeignKey(table, fm);
        }
        this.processExtendedClass(table, cm);
        return table;
    }

    private void processExtendedClass(Table table, ClassMapping cm) throws GeneratorException {
        Object extendClass = cm.getExtends();
        if (extendClass == null) {
            return;
        }
        ClassMapping extendCm = (ClassMapping)extendClass;
        String[] childIds = this._mappingHelper.getClassMappingSqlIdentity(cm, false);
        if (childIds.length != 0) {
            String[] parentTypes;
            String[] childTypes = this._mappingHelper.resolveTypeReferenceForIds(cm);
            if (childTypes.length != (parentTypes = this._mappingHelper.resolveTypeReferenceForIds(extendCm)).length) {
                throw new GeneratorException("Cannot resolve type for class '" + cm.getName() + "' from extend class '" + extendCm.getName() + "'");
            }
            for (int i = 0; i < childTypes.length; ++i) {
                if (childTypes[i].equalsIgnoreCase(parentTypes[i])) continue;
                throw new GeneratorException("Cannot resolve type for class '" + cm.getName() + "' from extend class '" + extendCm.getName() + "'");
            }
            return;
        }
        boolean isUseFieldIdentity = this._mappingHelper.isUseFieldIdentity(extendCm);
        Enumeration extendEf = extendCm.getClassChoice().enumerateFieldMapping();
        String keygenerator = extendCm.getKeyGenerator();
        KeyGenerator keyGen = null;
        if (keygenerator != null) {
            keyGen = this._keyGenRegistry.getKeyGenerator(keygenerator.toUpperCase());
        }
        table.setKeyGenerator(keyGen);
        while (extendEf.hasMoreElements()) {
            FieldMapping extendFm = (FieldMapping)extendEf.nextElement();
            if (extendFm.getSql() == null) continue;
            boolean isFieldIdentity = extendFm.getIdentity();
            if (!isUseFieldIdentity) {
                isFieldIdentity = this._mappingHelper.isIdentity(extendCm, extendFm);
            }
            if (!isFieldIdentity || extendFm.getSql().getManyKeyCount() > 0 || this.mergeIfDefInBothClasses(table, cm, extendFm)) continue;
            String[] sqlnames = extendFm.getSql().getName();
            String sqltype = extendFm.getSql().getType();
            TypeInfo typeInfo = null;
            ClassMapping cmRef = null;
            String[] refIdTypes = null;
            boolean isUseReferenceType = false;
            if (sqltype != null) {
                typeInfo = this._typeMapper.getType(sqltype);
            }
            if (typeInfo == null) {
                cmRef = this._mappingHelper.getClassMappingByName(extendFm.getType());
                if (cmRef == null) {
                    typeInfo = this._typeMapper.getType(extendFm.getType());
                    if (typeInfo == null) {
                        throw new TypeNotFoundException("can not resolve type " + extendFm.getType());
                    }
                } else {
                    isUseReferenceType = true;
                    refIdTypes = this._mappingHelper.resolveTypeReferenceForIds(extendFm.getType());
                    if (refIdTypes.length != sqlnames.length) {
                        throw new TypeNotFoundException("number of reference table's Id differs to number of field elements '" + extendFm.getName() + "' of class '" + extendCm.getName() + "'" + refIdTypes.length + "," + sqlnames.length);
                    }
                }
            }
            for (int i = 0; i < sqlnames.length; ++i) {
                Field field = this._schemaFactory.createField();
                field.setConfiguration(this._configuration);
                if (isUseReferenceType && (typeInfo = this._typeMapper.getType(refIdTypes[i])) == null) {
                    throw new TypeNotFoundException("can not find reference type " + refIdTypes[i] + " of class " + extendCm.getName());
                }
                field.setName(sqlnames[i]);
                field.setTable(table);
                field.setType(typeInfo);
                field.setIdentity(isFieldIdentity);
                field.setKeyGenerator(keyGen);
                if (isFieldIdentity) {
                    table.getPrimaryKey().addField(field);
                }
                table.addField(field);
            }
        }
        if (extendCm.getExtends() != null) {
            this.processExtendedClass(table, extendCm);
        }
    }

    private boolean mergeIfDefInBothClasses(Table table, ClassMapping cm, FieldMapping extendFm) {
        Enumeration ef = cm.getClassChoice().enumerateFieldMapping();
        while (ef.hasMoreElements()) {
            FieldMapping fm = (FieldMapping)ef.nextElement();
            String fname = fm.getName();
            if (fname == null || !fname.equalsIgnoreCase(extendFm.getName()) || fm.getSql() == null) continue;
            String[] sqlnames = fm.getSql().getName();
            for (int i = 0; i < sqlnames.length; ++i) {
                table.getField(sqlnames[i]).setIdentity(true);
            }
            return true;
        }
        return false;
    }

    private void addOneOneForeignKey(Table table, FieldMapping fm) throws GeneratorException {
        ForeignKey fk = this._schemaFactory.createForeignKey();
        fk.setConfiguration(this._configuration);
        fk.setTable(table);
        fk.setName(table.getName() + "_" + fm.getName());
        String[] fieldNames = fm.getSql().getName();
        for (int i = 0; i < fieldNames.length; ++i) {
            for (int j = 0; j < table.getFieldCount(); ++j) {
                Field field = table.getField(j);
                if (!fieldNames[i].equals(field.getName())) continue;
                fk.addField(field);
            }
        }
        ClassMapping cm = this._mappingHelper.getClassMappingByName(fm.getType());
        if (cm == null) {
            throw new GeneratorException("can not find class " + fm.getType());
        }
        String referenceTableName = cm.getMapTo().getTable();
        Table referenceTable = null;
        referenceTable = table.getSchema().getTable(referenceTableName);
        fk.setReferenceTable(referenceTable);
        String[] manykeys = fm.getSql().getManyKey();
        if (manykeys == null || manykeys.length == 0) {
            manykeys = this._mappingHelper.getClassMappingSqlIdentity(cm, true);
        }
        for (int i = 0; i < manykeys.length; ++i) {
            for (int j = 0; j < referenceTable.getFieldCount(); ++j) {
                Field field = referenceTable.getField(j);
                if (!manykeys[i].equals(field.getName())) continue;
                fk.addReferenceField(field);
            }
        }
        fk.setRelationType(0);
        table.addForeignKey(fk);
    }

    private void addResolveField(FieldMapping fm, ClassMapping cm) {
        String keyGen = cm.getKeyGenerator();
        ClassMapping resolveCm = null;
        if (this._resolveTable.containsKey(fm.getSql().getManyTable())) {
            resolveCm = (ClassMapping)this._resolveTable.get(fm.getSql().getManyTable());
        } else {
            resolveCm = new ClassMapping();
            resolveCm.setName(fm.getSql().getManyTable());
            resolveCm.setKeyGenerator(keyGen);
            MapTo mapto = new MapTo();
            mapto.setTable(fm.getSql().getManyTable());
            resolveCm.setMapTo(mapto);
            this._resolveTable.put(fm.getSql().getManyTable(), resolveCm);
        }
        FieldMapping resolveFm = new FieldMapping();
        resolveFm.setIdentity(true);
        resolveFm.setName(cm.getMapTo().getTable());
        resolveFm.setType(cm.getName());
        ClassChoice cc = resolveCm.getClassChoice();
        if (cc == null) {
            cc = new ClassChoice();
            resolveCm.setClassChoice(cc);
        }
        cc.addFieldMapping(resolveFm);
        Sql sql = new Sql();
        String[] sqlname = fm.getSql().getManyKey();
        if (sqlname == null || sqlname.length == 0) {
            this._mappingHelper.getClassMappingSqlIdentity(cm, true);
        }
        sql.setName(sqlname);
        resolveFm.setSql(sql);
    }

    protected final void write(String s) {
        String f = this._configuration.getStringValue("org.castor.ddlgen.CharFormat", "SENSITIVE");
        if ("LOWER".equalsIgnoreCase(f)) {
            this._printer.println(s.toLowerCase());
        } else if ("UPPER".equalsIgnoreCase(f)) {
            this._printer.println(s.toUpperCase());
        } else {
            this._printer.println(s);
        }
    }

    public abstract /* synthetic */ String getEngineConfigName();

    public abstract /* synthetic */ String getEngineConfigPath();

    public abstract /* synthetic */ String getEngineName();

    public abstract /* synthetic */ void initialize();
}

