/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.KeyNotFoundException;
import org.castor.ddlgen.WrongFormatException;

public class Configuration {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$ddlgen$Configuration == null ? (class$org$castor$ddlgen$Configuration = Configuration.class$("org.castor.ddlgen.Configuration")) : class$org$castor$ddlgen$Configuration));
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private final Properties _conf = new Properties();
    static /* synthetic */ Class class$org$castor$ddlgen$Configuration;

    public Configuration() {
        this.addProperties(System.getProperties());
    }

    public final boolean getBoolValue(String key) throws WrongFormatException, KeyNotFoundException {
        String value = this.getStringValue(key);
        if (value == null) {
            throw new KeyNotFoundException("can not found key " + key);
        }
        if (TRUE.equals(value)) {
            return true;
        }
        if (FALSE.equals(value)) {
            return false;
        }
        throw new WrongFormatException("require boolean (true/false), receive " + value + " for key=" + key);
    }

    public final boolean getBoolValue(String key, boolean defaultValue) {
        String value = null;
        try {
            value = this.getStringValue(key);
        }
        catch (KeyNotFoundException e) {
            return defaultValue;
        }
        if (value == null) {
            return defaultValue;
        }
        if (TRUE.equals(value)) {
            return true;
        }
        if (FALSE.equals(value)) {
            return false;
        }
        return defaultValue;
    }

    public final Integer getInteger(String name) {
        String value = this._conf.getProperty(name);
        if (value == null) {
            return null;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public final String getStringValue(String key) throws KeyNotFoundException {
        String value = (String)((Hashtable)this._conf).get(key);
        if (value == null || "".equals(value)) {
            throw new KeyNotFoundException("Can not find value correspondence to " + key);
        }
        return value;
    }

    public final String getStringValue(String key, String defaultValue) {
        String value = (String)((Hashtable)this._conf).get(key);
        if (value == null || "".equals(value)) {
            value = defaultValue;
        }
        return value;
    }

    public final void addProperties(Properties props) {
        if (props != null) {
            Enumeration e = ((Hashtable)props).keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = ((Hashtable)props).get(key);
                ((Hashtable)this._conf).put(key, value);
            }
        }
    }

    public final void addProperties(String filename) throws GeneratorException {
        Properties props = new Properties();
        URL url = null;
        try {
            try {
                url = new URL(filename);
            }
            catch (MalformedURLException ex) {
                url = this.getClass().getClassLoader().getResource(filename);
            }
            if (url == null) {
                String msg = "Could not obtain the configuration file '" + filename + "' from the Castor JAR.";
                LOG.error((Object)msg);
                throw new GeneratorException(msg);
            }
            props.load(url.openStream());
            this.addProperties(props);
        }
        catch (IOException ex) {
            String msg = "Could not read the configuration file '" + url.toExternalForm() + "' from the Castor JAR.";
            LOG.error((Object)msg, (Throwable)ex);
            throw new GeneratorException(msg, ex);
        }
    }

    public final void setProperty(String key, String value) {
        ((Hashtable)this._conf).put(key, value);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

