/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen.engine.postgresql;

import java.text.MessageFormat;
import org.castor.ddlgen.DDLGenConfiguration;
import org.castor.ddlgen.keygenerator.SequenceKeyGenerator;
import org.castor.ddlgen.keygenerator.SequenceKeyGeneratorFactory;
import org.castor.ddlgen.schemaobject.KeyGenerator;

public final class PostgresqlSequenceKeyGeneratorFactory
extends SequenceKeyGeneratorFactory {
    public String toCreateDDL(KeyGenerator key) {
        SequenceKeyGenerator sequenceKey = (SequenceKeyGenerator)key;
        DDLGenConfiguration conf = sequenceKey.getConfiguration();
        StringBuffer buff = new StringBuffer();
        String tableName = sequenceKey.getTable().getName();
        String pkList = this.toPrimaryKeyList(key.getTable());
        String pkTypeList = this.toPrimaryKeyTypeList(key.getTable());
        String sequenceName = MessageFormat.format(sequenceKey.getSequence(), tableName, pkList);
        String newline = conf.getStringValue("org.castor.ddlgen.Newline", DDLGenConfiguration.DEFAULT_NEWLINE);
        String indent = conf.getStringValue("org.castor.ddlgen.Indention", "    ");
        buff.append(newline).append(newline);
        buff.append("CREATE SEQUENCE ").append(sequenceName);
        buff.append(newline).append(indent);
        buff.append(" INCREMENT 1 ").append("MAXVALUE ").append(Integer.MAX_VALUE).append(" START 1");
        buff.append(";");
        if (sequenceKey.isTrigger()) {
            String triggerName = null;
            triggerName = sequenceName.matches(".*SEQ.*") ? sequenceName.replaceAll("SEQ", "TRG") : "TRG" + sequenceName;
            String triggerTemp = conf.getStringValue("org.castor.ddlgen.TriggerTemplate", "");
            triggerTemp = triggerTemp.replaceAll("<trigger_name>", triggerName);
            triggerTemp = triggerTemp.replaceAll("<sequence_name>", sequenceName);
            triggerTemp = triggerTemp.replaceAll("<table_name>", tableName);
            triggerTemp = triggerTemp.replaceAll("<pk_name>", pkList);
            triggerTemp = triggerTemp.replaceAll("<pk_type>", pkTypeList);
            buff.append(newline);
            buff.append(newline);
            buff.append(triggerTemp);
        }
        return buff.toString();
    }

    public String toDropDDL(KeyGenerator key) {
        return "";
    }
}

