/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.ddlgen.DDLGenConfiguration;
import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.KeyGeneratorFactory;
import org.castor.ddlgen.schemaobject.KeyGenerator;
import org.exolab.castor.mapping.xml.KeyGeneratorDef;

public final class KeyGeneratorRegistry {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$ddlgen$KeyGeneratorRegistry == null ? (class$org$castor$ddlgen$KeyGeneratorRegistry = KeyGeneratorRegistry.class$("org.castor.ddlgen.KeyGeneratorRegistry")) : class$org$castor$ddlgen$KeyGeneratorRegistry));
    private final DDLGenConfiguration _config;
    private final Map _factories = new Hashtable();
    private final Map _generators = new Hashtable();
    static /* synthetic */ Class class$org$castor$ddlgen$KeyGeneratorRegistry;

    public KeyGeneratorRegistry(DDLGenConfiguration config) {
        this._config = config;
        String prop = config.getStringValue("org.castor.ddlgen.KeyGeneratorFactories", "");
        StringTokenizer tokenizer = new StringTokenizer(prop, ",");
        ClassLoader loader = (class$org$castor$ddlgen$KeyGeneratorRegistry == null ? (class$org$castor$ddlgen$KeyGeneratorRegistry = KeyGeneratorRegistry.class$("org.castor.ddlgen.KeyGeneratorRegistry")) : class$org$castor$ddlgen$KeyGeneratorRegistry).getClassLoader();
        while (tokenizer.hasMoreTokens()) {
            String classname = tokenizer.nextToken().trim();
            try {
                Class<?> cls = loader.loadClass(classname);
                KeyGeneratorFactory factory = (KeyGeneratorFactory)cls.newInstance();
                this._factories.put(factory.getAlgorithmName(), factory);
                if (factory.hasMandatoryParameters()) continue;
                KeyGenerator generator = factory.createKeyGenerator();
                this._generators.put(generator.getAlias(), generator);
            }
            catch (Exception ex) {
                String msg = "Problem instantiating key generator factory: ";
                LOG.error((Object)(msg + classname), (Throwable)ex);
            }
        }
    }

    public KeyGenerator createKeyGenerator(KeyGeneratorDef definition) throws GeneratorException {
        String algorithm = definition.getName();
        KeyGeneratorFactory factory = this.getKeyGeneratorFactory(algorithm);
        if (factory == null) {
            LOG.warn((Object)("Unknown KeyGeneratorFactory: " + algorithm));
            throw new GeneratorException("Unknown KeyGeneratorFactory: " + algorithm);
        }
        KeyGenerator generator = factory.createKeyGenerator(definition);
        generator.setConfiguration(this._config);
        this._generators.put(generator.getAlias(), generator);
        return generator;
    }

    public KeyGeneratorFactory getKeyGeneratorFactory(String algorithm) throws GeneratorException {
        if (algorithm == null) {
            throw new GeneratorException("No algorithm specified");
        }
        KeyGeneratorFactory factory = (KeyGeneratorFactory)this._factories.get(algorithm);
        if (factory == null) {
            LOG.warn((Object)("Unknown KeyGeneratorFactory: " + algorithm));
            throw new GeneratorException("Unknown KeyGeneratorFactory: " + algorithm);
        }
        return factory;
    }

    public Collection getKeyGeneratorFactories() {
        return Collections.unmodifiableCollection(this._factories.values());
    }

    public Collection getKeyGeneratorFactoryAlgorithms() {
        return Collections.unmodifiableCollection(this._factories.keySet());
    }

    public KeyGenerator getKeyGenerator(String alias) throws GeneratorException {
        if (alias == null) {
            throw new GeneratorException("No keygenerator alias specified");
        }
        KeyGenerator generator = (KeyGenerator)this._generators.get(alias);
        if (generator == null) {
            LOG.warn((Object)("Unknown KeyGenerator: " + alias));
            throw new GeneratorException("Unknown KeyGenerator: " + alias);
        }
        return generator;
    }

    public Collection getKeyGenerators() {
        return Collections.unmodifiableCollection(this._generators.values());
    }

    public Collection getKeyGeneratorAliases() {
        return Collections.unmodifiableCollection(this._generators.keySet());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

