/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.ddlgen.Generator;
import org.castor.ddlgen.GeneratorFactory;
import org.castor.mapping.MappingUnmarshaller;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.util.CommandLineOptions;

public final class Main {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$ddlgen$Main == null ? (class$org$castor$ddlgen$Main = Main.class$("org.castor.ddlgen.Main")) : class$org$castor$ddlgen$Main));
    static /* synthetic */ Class class$org$castor$ddlgen$Main;

    public static void main(String[] args) {
        CommandLineOptions allOptions = new CommandLineOptions();
        allOptions.addFlag("m", "mapping.xml", "input mapping file.");
        allOptions.addFlag("c", "ddl.properties", "configuration file.", true);
        allOptions.addFlag("d", "mysql.properties", "specific database configuration file.", true);
        allOptions.addFlag("e", "MySQL", "database engine, for example MySQL, Oracle", true);
        allOptions.addFlag("o", "output.sql", "output ddl file", true);
        allOptions.addFlag("h", "", "Displays this help screen.", true);
        Properties options = allOptions.getOptions(args);
        String mappingName = options.getProperty("m");
        String ddlName = options.getProperty("o");
        String globalConfig = options.getProperty("c");
        String specificConfig = options.getProperty("d");
        String engine = options.getProperty("e");
        if (options.getProperty("h") != null || mappingName == null) {
            PrintWriter pw = new PrintWriter(System.out, true);
            allOptions.printHelp(pw);
            pw.flush();
            System.exit(0);
        }
        if (ddlName == null) {
            ddlName = mappingName.replaceAll(".xml", ".sql");
        }
        LOG.info((Object)("mapping file: " + mappingName));
        LOG.info((Object)("ddl output file: " + ddlName));
        LOG.info((Object)("global configuration file: " + globalConfig));
        LOG.info((Object)("specific database configuration file: " + specificConfig));
        LOG.info((Object)("database: " + engine));
        try {
            Generator generator = GeneratorFactory.createDDLGenerator(engine, globalConfig, specificConfig);
            Mapping mapping = new Mapping();
            mapping.loadMapping(mappingName);
            new MappingUnmarshaller().loadMappingOnly(mapping);
            generator.setMapping(mapping);
            generator.generateDDL(new FileOutputStream(ddlName));
        }
        catch (Exception ex) {
            LOG.error((Object)("Error: " + ex.getMessage()), (Throwable)ex);
        }
    }

    private Main() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

