/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen.engine.postgresql;

import org.castor.ddlgen.DDLWriter;
import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.keygenerator.IdentityKeyGenerator;
import org.castor.ddlgen.schemaobject.Field;

public final class PostgresqlField
extends Field {
    public void toCreateDDL(DDLWriter writer) throws GeneratorException {
        writer.print(this.getName());
        writer.print(" ");
        if (this.isIdentity() && this.getKeyGenerator() instanceof IdentityKeyGenerator) {
            if ("integer".equalsIgnoreCase(this.getType().getSqlType())) {
                writer.print("SERIAL");
            } else {
                writer.print("BIGSERIAL");
            }
        } else {
            writer.print(this.getType().toDDL(this));
        }
        if (this.isIdentity() || this.isRequired()) {
            writer.print(" NOT NULL");
        }
    }

    public String toCreateDDL() throws GeneratorException {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName()).append(" ");
        if (this.isIdentity() && this.getKeyGenerator() instanceof IdentityKeyGenerator) {
            if ("integer".equalsIgnoreCase(this.getType().getSqlType())) {
                sb.append("SERIAL");
            } else {
                sb.append("BIGSERIAL");
            }
        } else {
            sb.append(this.getType().toDDL(this));
        }
        if (this.isIdentity() || this.isRequired()) {
            sb.append(" NOT NULL");
        }
        return sb.toString();
    }
}

