/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen.schemaobject;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.ddlgen.DDLWriter;
import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.schemaobject.AbstractSchemaObject;
import org.castor.ddlgen.schemaobject.Field;
import org.castor.ddlgen.schemaobject.Table;

public abstract class ForeignKey
extends AbstractSchemaObject {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$ddlgen$schemaobject$ForeignKey == null ? (class$org$castor$ddlgen$schemaobject$ForeignKey = ForeignKey.class$("org.castor.ddlgen.schemaobject.ForeignKey")) : class$org$castor$ddlgen$schemaobject$ForeignKey));
    public static final int ONE_ONE = 0;
    public static final int ONE_MANY = 1;
    public static final int MANY_MANY = 2;
    private int _relationType = 0;
    private List _referencedFields = new ArrayList();
    private Table _referencedTable;
    private List _fields = new ArrayList();
    private Table _table;
    static /* synthetic */ Class class$org$castor$ddlgen$schemaobject$ForeignKey;

    public final void setRelationType(int relationType) {
        this._relationType = relationType;
    }

    public final int getRelationType() {
        return this._relationType;
    }

    public final void addReferenceField(Field field) {
        this._referencedFields.add(field);
    }

    public final int getReferenceFieldCount() {
        return this._referencedFields.size();
    }

    public final Field getReferenceField(int index) {
        return (Field)this._referencedFields.get(index);
    }

    public final void setReferenceTable(Table table) {
        this._referencedTable = table;
    }

    public final Table getReferenceTable() {
        return this._referencedTable;
    }

    public final void addField(Field field) {
        this._fields.add(field);
    }

    public final int getFieldCount() {
        return this._fields.size();
    }

    public final Field getField(int index) {
        return (Field)this._fields.get(index);
    }

    public final void setTable(Table table) {
        this._table = table;
    }

    public final Table getTable() {
        return this._table;
    }

    protected final void fieldNames(DDLWriter writer) {
        String delimiter = ",";
        for (int i = 0; i < this.getFieldCount(); ++i) {
            if (i > 0) {
                writer.print(delimiter);
                writer.print(" ");
            }
            writer.print(this.getField(i).getName());
        }
    }

    protected final void referencedFieldNames(DDLWriter writer) {
        String delimiter = ",";
        for (int i = 0; i < this.getReferenceFieldCount(); ++i) {
            if (i > 0) {
                writer.print(delimiter);
                writer.print(" ");
            }
            writer.print(this.getReferenceField(i).getName());
        }
    }

    public final void toDropDDL(DDLWriter writer) {
    }

    public final void merge(ForeignKey fk) throws GeneratorException {
        int i;
        if (fk == null) {
            String msg = "Foreign key to merge is missing.";
            LOG.error((Object)msg);
            throw new GeneratorException(msg);
        }
        if (!AbstractSchemaObject.equals(this.getName(), fk.getName())) {
            String msg = "Name of foreign key differs from: " + this.getName();
            LOG.error((Object)msg);
            throw new GeneratorException(msg);
        }
        if (!AbstractSchemaObject.equals(this.getTable(), fk.getTable())) {
            String msg = "Table of foreign key differs from: " + this.getTable().getName();
            LOG.error((Object)msg);
            throw new GeneratorException(msg);
        }
        if (this.getFieldCount() != fk.getFieldCount()) {
            String msg = "Field count of foreign key differs from: " + this.getFieldCount();
            LOG.error((Object)msg);
            throw new GeneratorException(msg);
        }
        for (i = 0; i < this.getFieldCount(); ++i) {
            if (AbstractSchemaObject.equals(this.getField(i), fk.getField(i))) continue;
            String msg = "Field of foreign key differs from: " + this.getField(i).getName();
            LOG.error((Object)msg);
            throw new GeneratorException(msg);
        }
        if (!AbstractSchemaObject.equals(this.getReferenceTable().getName(), fk.getReferenceTable().getName())) {
            String msg = "Referenced table of foreign key differs from: " + this.getReferenceTable().getName();
            LOG.error((Object)msg);
            throw new GeneratorException(msg);
        }
        if (this.getReferenceFieldCount() != fk.getReferenceFieldCount()) {
            String msg = "Referenced field count of foreign key differs from: " + this.getReferenceFieldCount();
            LOG.error((Object)msg);
            throw new GeneratorException(msg);
        }
        for (i = 0; i < this.getReferenceFieldCount(); ++i) {
            if (AbstractSchemaObject.equals(this.getReferenceField(i), fk.getReferenceField(i))) continue;
            String msg = "Referenced field of foreign key differs from: " + this.getReferenceField(i).getName();
            LOG.error((Object)msg);
            throw new GeneratorException(msg);
        }
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        ForeignKey fk = (ForeignKey)other;
        return AbstractSchemaObject.equals(this.getName(), fk.getName()) && AbstractSchemaObject.equals(this._table, fk._table) && AbstractSchemaObject.equals(this._fields, fk._fields) && AbstractSchemaObject.equals(this._referencedTable, fk._referencedTable) && AbstractSchemaObject.equals(this._referencedFields, fk._referencedFields) && this._relationType == fk._relationType;
    }

    public final int hashCode() {
        int hashCode = 0;
        if (this.getName() != null) {
            hashCode += this.getName().hashCode();
        }
        hashCode *= 17;
        if (this._table != null) {
            hashCode += this._table.hashCode();
        }
        hashCode *= 17;
        hashCode += ((Object)this._fields).hashCode();
        hashCode *= 17;
        if (this._referencedTable != null) {
            hashCode += this._referencedTable.hashCode();
        }
        hashCode *= 17;
        hashCode += ((Object)this._referencedFields).hashCode();
        hashCode *= 17;
        return hashCode += this._relationType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

