/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen.typeinfo;

import org.castor.ddlgen.DDLGenConfiguration;
import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.schemaobject.Field;
import org.castor.ddlgen.typeinfo.AbstractType;

public final class LobType
extends AbstractType {
    private static final int THOUSAND = 1024;
    private final Integer _defaultLength;

    public LobType(String jdbcType, String sqlType, DDLGenConfiguration conf) {
        super(jdbcType, sqlType);
        String param = "default_" + jdbcType + "_length";
        this._defaultLength = conf.getInteger(param);
    }

    public String toDDL(Field field) throws GeneratorException {
        Integer length = field.getLength();
        if (length == null) {
            length = this._defaultLength;
        }
        if (length == null) {
            throw new GeneratorException("Reguired length attribute missing for field '" + field.getName() + "' of type '" + this.getJdbcType() + "'");
        }
        int len = length;
        String suffix = "";
        if (len >= 1024) {
            len /= 1024;
            suffix = "K";
        }
        if (len >= 1024) {
            len /= 1024;
            suffix = "M";
        }
        if (len >= 1024) {
            len /= 1024;
            suffix = "G";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSqlType());
        sb.append('(').append(len).append(suffix).append(')');
        return sb.toString();
    }
}

