/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.ddlgen.DDLGenConfiguration;
import org.castor.ddlgen.Generator;
import org.castor.ddlgen.GeneratorException;

public final class GeneratorRegistry {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$ddlgen$GeneratorRegistry == null ? (class$org$castor$ddlgen$GeneratorRegistry = GeneratorRegistry.class$("org.castor.ddlgen.GeneratorRegistry")) : class$org$castor$ddlgen$GeneratorRegistry));
    private Map _generators = new Hashtable();
    static /* synthetic */ Class class$org$castor$ddlgen$GeneratorRegistry;
    static /* synthetic */ Class class$org$castor$ddlgen$DDLGenConfiguration;

    public GeneratorRegistry(DDLGenConfiguration config) {
        String prop = config.getStringValue("org.castor.ddlgen.Generators", "");
        StringTokenizer tokenizer = new StringTokenizer(prop, ",");
        ClassLoader loader = (class$org$castor$ddlgen$GeneratorRegistry == null ? (class$org$castor$ddlgen$GeneratorRegistry = GeneratorRegistry.class$("org.castor.ddlgen.GeneratorRegistry")) : class$org$castor$ddlgen$GeneratorRegistry).getClassLoader();
        while (tokenizer.hasMoreTokens()) {
            String classname = tokenizer.nextToken().trim();
            try {
                Class<?> cls = loader.loadClass(classname);
                Class[] types = new Class[]{class$org$castor$ddlgen$DDLGenConfiguration == null ? GeneratorRegistry.class$("org.castor.ddlgen.DDLGenConfiguration") : class$org$castor$ddlgen$DDLGenConfiguration};
                Object[] params = new Object[]{config};
                Constructor<?> cst = cls.getConstructor(types);
                Generator generator = (Generator)cst.newInstance(params);
                this._generators.put(generator.getEngineName(), generator);
            }
            catch (Exception ex) {
                String msg = "Problem instantiating generator: ";
                LOG.error((Object)(msg + classname), (Throwable)ex);
            }
        }
    }

    public Generator getGenerator(String engine) throws GeneratorException {
        if (engine == null) {
            throw new GeneratorException("No database engine specified");
        }
        Generator generator = (Generator)this._generators.get(engine);
        if (generator == null) {
            throw new GeneratorException("Unknown DDL generator: " + engine);
        }
        return generator;
    }

    public Collection getGenerators() {
        return Collections.unmodifiableCollection(this._generators.values());
    }

    public Collection getEngineNames() {
        return Collections.unmodifiableCollection(this._generators.keySet());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

