/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen.engine.mssql;

import java.util.Date;
import org.castor.ddlgen.AbstractGenerator;
import org.castor.ddlgen.DDLGenConfiguration;
import org.castor.ddlgen.MappingHelper;
import org.castor.ddlgen.engine.mssql.MssqlSchemaFactory;
import org.castor.ddlgen.engine.mssql.MssqlTypeMapper;

public final class MssqlGenerator
extends AbstractGenerator {
    public static final String NAME = "mssql";
    public static final String ENGINE_CONFIG_PATH = "org/castor/ddlgen/engine/mssql/";
    public static final String ENGINE_CONFIG_NAME = "mssql.properties";

    public MssqlGenerator(DDLGenConfiguration configuration) {
        super(configuration);
    }

    public void initialize() {
        this.setMappingHelper(new MappingHelper());
        this.setTypeMapper(new MssqlTypeMapper(this.getConfiguration()));
        this.setSchemaFactory(new MssqlSchemaFactory());
    }

    public String getEngineName() {
        return NAME;
    }

    public String getEngineConfigPath() {
        return ENGINE_CONFIG_PATH;
    }

    public String getEngineConfigName() {
        return ENGINE_CONFIG_NAME;
    }

    public String generateHeader() {
        String newline = this.getConfiguration().getStringValue("org.castor.ddlgen.Newline", DDLGenConfiguration.DEFAULT_NEWLINE);
        StringBuffer buff = new StringBuffer("/* ");
        buff.append(newline);
        buff.append(new Date());
        buff.append(newline);
        buff.append("Castor DDL Generator from mapping for Microsoft SQL Server");
        buff.append(newline);
        buff.append(this.getConfiguration().getStringValue("org.castor.ddlgen.HeaderComment", ""));
        buff.append(newline);
        buff.append("*/");
        return buff.toString();
    }
}

