/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen.typeinfo;

import org.castor.ddlgen.DDLGenConfiguration;
import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.schemaobject.Field;
import org.castor.ddlgen.typeinfo.AbstractType;

public final class OptionalPrecisionDecimalsType
extends AbstractType {
    private final Integer _defaultPresision;
    private final Integer _defaultDecimals;

    public OptionalPrecisionDecimalsType(String jdbcType, String sqlType, DDLGenConfiguration conf) {
        super(jdbcType, sqlType);
        String paramPrecision = "default_" + jdbcType + "_precision";
        this._defaultPresision = conf.getInteger(paramPrecision);
        String paramDecimals = "default_" + jdbcType + "_decimals";
        this._defaultDecimals = conf.getInteger(paramDecimals);
    }

    public String toDDL(Field field) throws GeneratorException {
        Integer presision = field.getPrecision();
        Integer decimals = field.getDecimals();
        if (presision == null && decimals == null) {
            presision = this._defaultPresision;
            decimals = this._defaultDecimals;
        } else if (presision == null || decimals == null) {
            throw new GeneratorException("Precision or decimal attribute missing for field '" + field.getName() + "' of type '" + this.getJdbcType() + "'");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSqlType());
        if (presision != null) {
            sb.append('(').append(presision).append(", ").append(decimals).append(')');
        }
        return sb.toString();
    }
}

