/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen.schemaobject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.ddlgen.DDLWriter;
import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.schemaobject.AbstractSchemaObject;
import org.castor.ddlgen.schemaobject.Field;
import org.castor.ddlgen.schemaobject.ForeignKey;
import org.castor.ddlgen.schemaobject.Index;
import org.castor.ddlgen.schemaobject.KeyGenerator;
import org.castor.ddlgen.schemaobject.PrimaryKey;
import org.castor.ddlgen.schemaobject.Schema;

public abstract class Table
extends AbstractSchemaObject {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$ddlgen$schemaobject$Table == null ? (class$org$castor$ddlgen$schemaobject$Table = Table.class$("org.castor.ddlgen.schemaobject.Table")) : class$org$castor$ddlgen$schemaobject$Table));
    private List _indices = new ArrayList();
    private List _foreignKeys = new ArrayList();
    private List _fields = new ArrayList();
    private Map _fieldMap = new HashMap();
    private KeyGenerator _keyGenerator;
    private PrimaryKey _primaryKey;
    private Schema _schema;
    static /* synthetic */ Class class$org$castor$ddlgen$schemaobject$Table;

    public final void addIndex(Index index) {
        this._indices.add(index);
    }

    public final int getIndexCount() {
        return this._indices.size();
    }

    public final Index getIndex(int index) {
        return (Index)this._indices.get(index);
    }

    public final void addForeignKey(ForeignKey foreignKey) {
        this._foreignKeys.add(foreignKey);
    }

    public final int getForeignKeyCount() {
        return this._foreignKeys.size();
    }

    public final ForeignKey getForeignKey(int index) {
        return (ForeignKey)this._foreignKeys.get(index);
    }

    public final void addField(Field field) {
        this._fields.add(field);
        this._fieldMap.put(field.getName(), field);
    }

    public final int getFieldCount() {
        return this._fields.size();
    }

    public final Field getField(int index) {
        return (Field)this._fields.get(index);
    }

    public final Field getField(String name) {
        return (Field)this._fieldMap.get(name);
    }

    public final void setKeyGenerator(KeyGenerator keyGenerator) {
        this._keyGenerator = keyGenerator;
    }

    public final KeyGenerator getKeyGenerator() {
        return this._keyGenerator;
    }

    public final void setPrimaryKey(PrimaryKey primaryKey) {
        this._primaryKey = primaryKey;
    }

    public final PrimaryKey getPrimaryKey() {
        return this._primaryKey;
    }

    public final void setSchema(Schema schema) {
        this._schema = schema;
    }

    public final Schema getSchema() {
        return this._schema;
    }

    protected final void fields(DDLWriter writer) throws GeneratorException {
        String delimiter = ",";
        writer.indent();
        for (int i = 0; i < this.getFieldCount(); ++i) {
            if (i > 0) {
                writer.println(delimiter);
            }
            this.getField(i).toCreateDDL(writer);
        }
        writer.unindent();
    }

    public final void merge(Table table) throws GeneratorException {
        int j;
        int i;
        if (table == null) {
            String msg = "Table to merge is missing.";
            LOG.error((Object)msg);
            throw new GeneratorException(msg);
        }
        if (!AbstractSchemaObject.equals(this.getName(), table.getName())) {
            String msg = "Name of table differs from: " + this.getName();
            LOG.error((Object)msg);
            throw new GeneratorException(msg);
        }
        if (this.getFieldCount() != table.getFieldCount()) {
            String msg = "Field count of table differs from: " + this.getFieldCount();
            LOG.error((Object)msg);
            throw new GeneratorException(msg);
        }
        for (i = 0; i < this.getFieldCount(); ++i) {
            Field field1 = this.getField(i);
            Field field2 = null;
            for (j = 0; j < table.getFieldCount(); ++j) {
                field2 = table.getField(j);
                if (!AbstractSchemaObject.equals(field1.getName(), field2.getName())) break;
            }
            field1.merge(field2);
        }
        for (i = 0; i < this.getForeignKeyCount(); ++i) {
            ForeignKey fk1 = this.getForeignKey(i);
            ForeignKey fk2 = null;
            for (j = 0; j < table.getForeignKeyCount(); ++j) {
                fk2 = table.getForeignKey(j);
                if (!AbstractSchemaObject.equals(fk1.getName(), fk2.getName())) break;
            }
            fk1.merge(fk2);
        }
        if (this._keyGenerator != null) {
            this._keyGenerator.merge(table.getKeyGenerator());
        }
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        Table table = (Table)other;
        return AbstractSchemaObject.equals(this.getName(), table.getName()) && AbstractSchemaObject.equals(this._schema, table._schema) && AbstractSchemaObject.equals(this._primaryKey, table._primaryKey) && AbstractSchemaObject.equals(this._keyGenerator, table._keyGenerator) && AbstractSchemaObject.equals(this._fields, table._fields) && AbstractSchemaObject.equals(this._foreignKeys, table._foreignKeys) && AbstractSchemaObject.equals(this._indices, table._indices);
    }

    public final int hashCode() {
        int hashCode = 0;
        if (this.getName() != null) {
            hashCode += this.getName().hashCode();
        }
        hashCode *= 17;
        if (this._schema != null) {
            hashCode += this._schema.hashCode();
        }
        hashCode *= 17;
        if (this._primaryKey != null) {
            hashCode += this._primaryKey.hashCode();
        }
        hashCode *= 17;
        if (this._keyGenerator != null) {
            hashCode += this._keyGenerator.hashCode();
        }
        hashCode *= 17;
        hashCode += ((Object)this._fields).hashCode();
        hashCode *= 17;
        hashCode += ((Object)this._foreignKeys).hashCode();
        hashCode *= 17;
        return hashCode += ((Object)this._indices).hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

