/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen;

import org.castor.ddlgen.DDLGenConfiguration;
import org.castor.ddlgen.Generator;
import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.GeneratorRegistry;
import org.castor.ddlgen.KeyGeneratorRegistry;

public final class GeneratorFactory {
    public static Generator createDDLGenerator(String engine, String globalConf, String specificConf) throws GeneratorException {
        DDLGenConfiguration config = new DDLGenConfiguration();
        config.addProperties("org/castor/ddlgen/ddlgen.properties");
        if (globalConf != null) {
            config.addProperties(globalConf);
        }
        GeneratorRegistry registry = new GeneratorRegistry(config);
        String eng = config.getStringValue("org.castor.ddlgen.DefaultEngine", "");
        if (engine != null) {
            eng = engine;
        }
        Generator gen = registry.getGenerator(eng.toLowerCase());
        config.addProperties(gen.getEngineConfigPath() + gen.getEngineConfigName());
        if (specificConf != null) {
            config.addProperties(specificConf);
        }
        gen.setKeyGenRegistry(new KeyGeneratorRegistry(config));
        gen.initialize();
        return gen;
    }

    private GeneratorFactory() {
    }
}

