/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen;

import java.util.Enumeration;
import java.util.Vector;
import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.TypeMapper;
import org.castor.ddlgen.TypeNotFoundException;
import org.castor.ddlgen.typeinfo.TypeInfo;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;

public final class MappingHelper {
    private Mapping _mapping;
    private TypeMapper _typeMapper;

    public Mapping getMapping() {
        return this._mapping;
    }

    public void setMapping(Mapping mapping) {
        this._mapping = mapping;
    }

    public TypeMapper getTypeMapper() {
        return this._typeMapper;
    }

    public void setTypeMapper(TypeMapper typeMapper) {
        this._typeMapper = typeMapper;
    }

    public ClassMapping getClassMappingByName(String name) {
        Enumeration ec = this._mapping.getRoot().enumerateClassMapping();
        while (ec.hasMoreElements()) {
            ClassMapping cm = (ClassMapping)ec.nextElement();
            String cmName = cm.getName();
            if (cmName == null || !cmName.equals(name)) continue;
            return cm;
        }
        return null;
    }

    public synchronized String[] resolveTypeReferenceForIds(String className) throws GeneratorException {
        ClassMapping cm = this.getClassMappingByName(className);
        if (cm != null) {
            return this.resolveTypeReferenceForIds(cm);
        }
        throw new GeneratorException("can not find class " + className);
    }

    public String[] resolveTypeReferenceForIds(ClassMapping cm) throws GeneratorException {
        boolean isFoundKey = false;
        String[] ids = cm.getIdentity();
        Vector<String> types = new Vector<String>();
        Enumeration ef = cm.getClassChoice().enumerateFieldMapping();
        boolean isExistFieldId = this.isUseFieldIdentity(cm);
        while (ef.hasMoreElements()) {
            FieldMapping fm = (FieldMapping)ef.nextElement();
            if (isExistFieldId && fm.getIdentity()) {
                TypeInfo typeinfo = null;
                String sqltype = fm.getSql().getType();
                if (sqltype != null) {
                    typeinfo = this._typeMapper.getType(sqltype);
                }
                if (typeinfo == null) {
                    String[] refRefType = this.resolveTypeReferenceForIds(fm.getType());
                    for (int l = 0; l < refRefType.length; ++l) {
                        types.add(refRefType[l]);
                        isFoundKey = true;
                    }
                    continue;
                }
                for (int i = 0; i < fm.getSql().getNameCount(); ++i) {
                    types.add(fm.getSql().getType());
                    isFoundKey = true;
                }
                continue;
            }
            if (isExistFieldId) continue;
            String fieldName = fm.getName();
            for (int j = 0; j < ids.length; ++j) {
                if (!fieldName.equals(ids[j])) continue;
                TypeInfo typeinfo = null;
                String sqltype = fm.getSql().getType();
                if (sqltype != null) {
                    typeinfo = this._typeMapper.getType(sqltype);
                }
                if (typeinfo == null) {
                    int l;
                    ClassMapping cmRef = this.getClassMappingByName(fm.getType());
                    if (cmRef == null) {
                        typeinfo = this._typeMapper.getType(fm.getType());
                        if (typeinfo == null) {
                            throw new TypeNotFoundException("Can't resolve type " + fm.getType());
                        }
                        int count = fm.getSql().getNameCount();
                        if (count == 0) {
                            count = fm.getSql().getManyKeyCount();
                        }
                        for (l = 0; l < count; ++l) {
                            types.add(fm.getType());
                            isFoundKey = true;
                        }
                        continue;
                    }
                    String[] refRefType = this.resolveTypeReferenceForIds(fm.getType());
                    for (l = 0; l < refRefType.length; ++l) {
                        types.add(refRefType[l]);
                        isFoundKey = true;
                    }
                    continue;
                }
                types.add(fm.getSql().getType());
                isFoundKey = true;
            }
        }
        if (!isFoundKey && cm.getExtends() != null) {
            ClassMapping extendClass = (ClassMapping)cm.getExtends();
            String[] refRefType = this.resolveTypeReferenceForIds(extendClass);
            for (int l = 0; l < refRefType.length; ++l) {
                types.add(refRefType[l]);
            }
        }
        return types.toArray(new String[types.size()]);
    }

    public boolean isUseFieldIdentity(ClassMapping cm) {
        Enumeration ef = cm.getClassChoice().enumerateFieldMapping();
        while (ef.hasMoreElements()) {
            FieldMapping fm = (FieldMapping)ef.nextElement();
            if (!fm.getIdentity()) continue;
            return true;
        }
        return false;
    }

    public boolean isIdentity(ClassMapping cm, FieldMapping fm) {
        String[] ids = cm.getIdentity();
        String fieldName = fm.getName();
        for (int j = 0; j < ids.length; ++j) {
            if (!ids[j].equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    public String[] getClassMappingSqlIdentity(ClassMapping cm, boolean ext) {
        Vector<String> ids = new Vector<String>();
        String[] identities = cm.getIdentity();
        if (ext && cm.getExtends() != null && identities.length == 0) {
            identities = this.getClassMappingIdentity((ClassMapping)cm.getExtends());
        }
        Enumeration ef = cm.getClassChoice().enumerateFieldMapping();
        boolean isExistFieldId = this.isUseFieldIdentity(cm);
        while (ef.hasMoreElements()) {
            FieldMapping fm = (FieldMapping)ef.nextElement();
            if (isExistFieldId && fm.getIdentity()) {
                isExistFieldId = true;
                int ncount = fm.getSql().getNameCount();
                for (int i = 0; i < ncount; ++i) {
                    ids.add(fm.getSql().getName(i));
                }
                continue;
            }
            if (isExistFieldId) continue;
            String fieldName = fm.getName();
            for (int j = 0; j < identities.length; ++j) {
                if (!fieldName.equals(identities[j])) continue;
                int ncount = fm.getSql().getNameCount();
                for (int i = 0; i < ncount; ++i) {
                    ids.add(fm.getSql().getName(i));
                }
            }
        }
        if (ext && cm.getExtends() != null && ids.size() == 0) {
            return this.getClassMappingSqlIdentity((ClassMapping)cm.getExtends(), ext);
        }
        return ids.toArray(new String[ids.size()]);
    }

    public String[] getClassMappingIdentity(ClassMapping cm) {
        Vector<String> ids = new Vector<String>();
        boolean isExistFieldId = false;
        Enumeration ef = cm.getClassChoice().enumerateFieldMapping();
        while (ef.hasMoreElements()) {
            FieldMapping fm = (FieldMapping)ef.nextElement();
            if (!isExistFieldId || !fm.getIdentity()) continue;
            isExistFieldId = true;
            ids.add(fm.getName());
        }
        if (!isExistFieldId) {
            String[] identities = cm.getIdentity();
            for (int i = 0; i < identities.length; ++i) {
                ids.add(identities[i]);
            }
        }
        if (cm.getExtends() != null && ids.size() == 0) {
            return this.getClassMappingIdentity((ClassMapping)cm.getExtends());
        }
        return ids.toArray(new String[ids.size()]);
    }
}

