/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen.engine.sapdb;

import java.text.MessageFormat;
import org.castor.ddlgen.DDLGenConfiguration;
import org.castor.ddlgen.DDLWriter;
import org.castor.ddlgen.keygenerator.SequenceKeyGenerator;
import org.castor.ddlgen.keygenerator.SequenceKeyGeneratorFactory;
import org.castor.ddlgen.schemaobject.KeyGenerator;

public final class SapdbSequenceKeyGeneratorFactory
extends SequenceKeyGeneratorFactory {
    public void toCreateDDL(KeyGenerator key, DDLWriter writer) {
        SequenceKeyGenerator sequenceKey = (SequenceKeyGenerator)key;
        String tableName = sequenceKey.getTable().getName();
        String pkList = this.toPrimaryKeyList(key.getTable());
        String sequenceName = MessageFormat.format(sequenceKey.getSequence(), tableName, pkList);
        writer.println();
        writer.println();
        writer.print("CREATE SEQUENCE ");
        writer.println(sequenceName);
        writer.println("INCREMENT BY 1 START WITH 1");
        writer.print("MAXVALUE ");
        writer.print(Integer.MAX_VALUE);
        writer.println(";");
        if (sequenceKey.isTrigger()) {
            String pkTypeList = this.toPrimaryKeyTypeList(key.getTable());
            String triggerName = null;
            triggerName = sequenceName.matches(".*SEQ.*") ? sequenceName.replaceAll("SEQ", "TRG") : "TRG" + sequenceName;
            DDLGenConfiguration conf = sequenceKey.getConfiguration();
            String triggerTemp = conf.getStringValue("org.castor.ddlgen.TriggerTemplate", "");
            triggerTemp = triggerTemp.replaceAll("<trigger_name>", triggerName);
            triggerTemp = triggerTemp.replaceAll("<sequence_name>", sequenceName);
            triggerTemp = triggerTemp.replaceAll("<table_name>", tableName);
            triggerTemp = triggerTemp.replaceAll("<pk_name>", pkList);
            triggerTemp = triggerTemp.replaceAll("<pk_type>", pkTypeList);
            writer.println();
            writer.println();
            writer.println(triggerTemp);
        }
    }

    public void toDropDDL(KeyGenerator key, DDLWriter writer) {
    }
}

