/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen.typeinfo;

import org.castor.ddlgen.DDLGenConfiguration;
import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.schemaobject.Field;
import org.castor.ddlgen.typeinfo.AbstractType;

public final class RequiredLengthType
extends AbstractType {
    private final Integer _defaultLength;
    private final String _postfix;

    public RequiredLengthType(String jdbcType, String sqlType, DDLGenConfiguration conf) {
        this(jdbcType, sqlType, "", conf);
    }

    public RequiredLengthType(String jdbcType, String sqlType, String postfix, DDLGenConfiguration conf) {
        super(jdbcType, sqlType);
        String param = "default_" + jdbcType + "_length";
        this._defaultLength = conf.getInteger(param);
        this._postfix = postfix;
    }

    public String toDDL(Field field) throws GeneratorException {
        Integer length = field.getLength();
        if (length == null) {
            length = this._defaultLength;
        }
        if (length == null) {
            throw new GeneratorException("Reguired length attribute missing for field '" + field.getName() + "' of type '" + this.getJdbcType() + "'");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.getSqlType());
        sb.append('(').append(length).append(')');
        sb.append(this._postfix);
        return sb.toString();
    }
}

