/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen.schemaobject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.ddlgen.schemaobject.AbstractSchemaObject;
import org.castor.ddlgen.schemaobject.Table;

public abstract class KeyGenerator
extends AbstractSchemaObject {
    private static final Log LOG = LogFactory.getLog(KeyGenerator.class);
    private String _alias;
    private Table _table;

    protected KeyGenerator(String name, String alias) {
        this.setName(name);
        this.setAlias(alias != null ? alias : name);
    }

    public final void setAlias(String alias) {
        this._alias = alias;
    }

    public final String getAlias() {
        return this._alias;
    }

    public final void setTable(Table table) {
        this._table = table;
    }

    public final Table getTable() {
        return this._table;
    }

    public final void merge(KeyGenerator keygen) {
        if (keygen == null) {
            String msg = "Merge table has no key generator";
            LOG.warn((Object)msg);
        } else if (this.getAlias() == null || !this.getAlias().equalsIgnoreCase(keygen.getAlias())) {
            String msg = "Merge table has different key generator: " + this.getAlias() + " / " + keygen.getAlias();
            LOG.warn((Object)msg);
        }
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        KeyGenerator kg = (KeyGenerator)other;
        return KeyGenerator.equals(this.getName(), kg.getName()) && KeyGenerator.equals(this._alias, kg._alias) && KeyGenerator.equals(this._table, kg._table);
    }

    public final int hashCode() {
        int hashCode = 0;
        if (this.getName() != null) {
            hashCode += this.getName().hashCode();
        }
        hashCode *= 17;
        if (this._alias != null) {
            hashCode += this._alias.hashCode();
        }
        hashCode *= 17;
        if (this._table != null) {
            hashCode += this._table.hashCode();
        }
        return hashCode;
    }
}

