/*
 * Decompiled with CFR 0.152.
 */
package org.castor.jdo.util;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.engine.AbstractConnectionFactory;
import org.castor.jdo.engine.DatabaseRegistry;
import org.castor.util.Messages;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.ClassMolder;

public final class JDOUtils {
    private static final Log LOG = LogFactory.getLog((Class)JDOUtils.class);

    public static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                if (!conn.isClosed()) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                LOG.warn((Object)Messages.message((String)"persist.connClosingFailed"), (Throwable)e);
            }
        }
    }

    public static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)Messages.message((String)"persist.rsClosingFailed"), (Throwable)e);
            }
        }
    }

    public static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                LOG.warn((Object)Messages.message((String)"persist.stClosingFailed"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDatabase(Database db) {
        if (db != null && !db.isClosed()) {
            Database database = db;
            synchronized (database) {
                if (db.isActive()) {
                    try {
                        db.rollback();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Failed to rollback an active transaction.", (Throwable)e);
                    }
                }
                if (!db.isClosed()) {
                    try {
                        db.close();
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Failed to close an open database.", (Throwable)e);
                    }
                }
            }
        }
    }

    public static ClassDescriptor getClassDescriptor(String db, Class type) throws MappingException {
        AbstractConnectionFactory cf = DatabaseRegistry.getConnectionFactory(db);
        ClassMolder cm = cf.getEngine().getClassMolderWithDependent(type);
        return cm.getClassDescriptor();
    }

    private JDOUtils() {
    }
}

