/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.engine.SQLTypeInfos;
import org.castor.persist.ProposedEntity;
import org.castor.util.Messages;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.PersistenceQuery;

final class PostgreSQLCallQuery
implements PersistenceQuery {
    private static Log _log = LogFactory.getFactory().getInstance(PostgreSQLCallQuery.class);
    private PreparedStatement _stmt;
    private ResultSet _rs;
    private final Class _javaClass;
    private final Class[] _types;
    private final Object[] _values;
    private final String _call;
    private Identity _lastIdentity;
    private int[] _sqlTypes;

    PostgreSQLCallQuery(String call, Class[] types, Class javaClass, String[] fields, int[] sqlTypes) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0) {
                query.append(",");
            }
            query.append(fields[i]);
            query.append("(");
            query.append(call);
            query.append(")");
        }
        this._call = query.toString();
        this._types = types;
        this._javaClass = javaClass;
        this._sqlTypes = sqlTypes;
        this._values = new Object[this._types.length];
    }

    public boolean absolute(int row) throws PersistenceException {
        return false;
    }

    public int size() throws PersistenceException {
        return 0;
    }

    public int getParameterCount() {
        return this._types.length;
    }

    public Class getParameterType(int index) throws ArrayIndexOutOfBoundsException {
        return this._types[index];
    }

    public void setParameter(int index, Object value) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        this._values[index] = value;
    }

    public Class getResultType() {
        return this._javaClass;
    }

    public void execute(Object conn, AccessMode accessMode, boolean scrollable) throws QueryException, PersistenceException {
        this.execute(conn, accessMode);
    }

    private void execute(Object conn, AccessMode accessMode) throws QueryException, PersistenceException {
        this._lastIdentity = null;
        try {
            this._stmt = ((Connection)conn).prepareStatement(this._call);
            int count = 1;
            for (int f = 0; f < this._sqlTypes.length; ++f) {
                for (int i = 0; i < this._values.length; ++i) {
                    this._stmt.setObject(count, this._values[i]);
                    ++count;
                }
            }
            for (int i = 0; i < this._values.length; ++i) {
                this._values[i] = null;
            }
            this._stmt.execute();
            this._rs = this._stmt.executeQuery();
        }
        catch (SQLException except) {
            if (this._stmt != null) {
                try {
                    this._stmt.close();
                }
                catch (SQLException e2) {
                    _log.warn((Object)Messages.message((String)"persist.stClosingFailed"), (Throwable)e2);
                }
            }
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except));
        }
    }

    public Identity nextIdentity(Identity identity) throws PersistenceException {
        try {
            if (this._lastIdentity == null) {
                if (!this._rs.next()) {
                    return null;
                }
                this._lastIdentity = new Identity(SQLTypeInfos.getValue(this._rs, 1, this._sqlTypes[0]));
                return this._lastIdentity;
            }
            while (this._lastIdentity.equals(identity)) {
                if (!this._rs.next()) {
                    this._lastIdentity = null;
                    return null;
                }
                this._lastIdentity = new Identity(SQLTypeInfos.getValue(this._rs, 1, this._sqlTypes[0]));
            }
            return this._lastIdentity;
        }
        catch (SQLException except) {
            this._lastIdentity = null;
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except));
        }
    }

    public void close() {
        if (this._rs != null) {
            try {
                this._rs.close();
            }
            catch (SQLException except) {
                _log.warn((Object)Messages.message((String)"persist.rsClosingFailed"), (Throwable)except);
            }
            this._rs = null;
        }
        if (this._stmt != null) {
            try {
                this._stmt.close();
            }
            catch (SQLException except) {
                _log.warn((Object)Messages.message((String)"persist.stClosingFailed"), (Throwable)except);
            }
            this._stmt = null;
        }
    }

    public Object fetch(ProposedEntity proposedObject) throws PersistenceException {
        try {
            for (int i = 1; i < this._sqlTypes.length; ++i) {
                proposedObject.setField(SQLTypeInfos.getValue(this._rs, i + 1, this._sqlTypes[i]), i - 1);
            }
            this._lastIdentity = this._rs.next() ? new Identity(SQLTypeInfos.getValue(this._rs, 1, this._sqlTypes[0])) : null;
        }
        catch (SQLException except) {
            throw new PersistenceException(Messages.format((String)"persist.nested", (Object)except));
        }
        return null;
    }
}

