/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.engine.AbstractConnectionFactory;
import org.castor.jdo.engine.DatabaseRegistry;
import org.castor.jdo.util.ClassLoadingUtils;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.castor.util.Configuration;
import org.castor.util.Messages;
import org.exolab.castor.jdo.CacheManager;
import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DatabaseNotFoundException;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.ObjectNotPersistentException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.Query;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.jdo.TransactionNotInProgressException;
import org.exolab.castor.jdo.engine.OQLQueryImpl;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.PersistenceInfoGroup;
import org.exolab.castor.persist.TxSynchronizable;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.Identity;
import org.exolab.castor.persist.spi.InstanceFactory;

public abstract class AbstractDatabaseImpl
implements Database {
    private static Log _log = LogFactory.getFactory().getInstance(AbstractDatabaseImpl.class);
    protected PersistenceInfoGroup _scope;
    protected TransactionContext _ctx;
    private ArrayList _synchronizables;
    protected int _lockTimeout;
    protected CallbackInterceptor _callback;
    protected InstanceFactory _instanceFactory;
    protected String _dbName;
    protected boolean _autoStore;
    protected ClassLoader _classLoader;
    private CacheManager cacheManager;

    public AbstractDatabaseImpl(String dbName, int lockTimeout, CallbackInterceptor callback, InstanceFactory instanceFactory, ClassLoader classLoader, boolean autoStore) throws DatabaseNotFoundException {
        this._autoStore = autoStore;
        AbstractConnectionFactory factory = null;
        try {
            factory = DatabaseRegistry.getConnectionFactory(dbName);
        }
        catch (MappingException ex) {
            throw new DatabaseNotFoundException(Messages.format((String)"jdo.dbNoMapping", (Object)dbName));
        }
        this._scope = new PersistenceInfoGroup(new LockEngine[]{factory.getEngine()});
        this._callback = callback;
        this._instanceFactory = instanceFactory;
        this._dbName = dbName;
        this._lockTimeout = lockTimeout;
        this._classLoader = classLoader;
        this.loadSynchronizables();
    }

    LockEngine getLockEngine() {
        return this._scope.getLockEngine();
    }

    public PersistenceInfoGroup getScope() {
        return this._scope;
    }

    public void setAutoStore(boolean autoStore) {
        this._autoStore = autoStore;
    }

    public boolean isAutoStore() {
        if (this._ctx != null) {
            return this._ctx.isAutoStore();
        }
        return this._autoStore;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String getDatabaseName() {
        return this._dbName;
    }

    public abstract void close() throws PersistenceException;

    public boolean isClosed() {
        return this._scope == null;
    }

    public boolean isLocked(Class cls, Object identity) throws PersistenceException {
        if (identity == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        if (this._scope == null) {
            throw new PersistenceException(Messages.message((String)"jdo.dbClosed"));
        }
        if (this.isActive()) {
            return this._ctx.isLocked(cls, new Identity(identity), this._scope.getLockEngine());
        }
        return false;
    }

    public Object load(Class type, Object identity) throws ObjectNotFoundException, LockNotGrantedException, TransactionNotInProgressException, PersistenceException {
        return this.load(type, identity, null, null);
    }

    public Object load(Class type, Object identity, Object object) throws TransactionNotInProgressException, ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        return this.load(type, identity, object, null);
    }

    public Object load(Class type, Object identity, AccessMode mode) throws TransactionNotInProgressException, ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        return this.load(type, identity, null, mode);
    }

    private Object load(Class type, Object identity, Object object, AccessMode mode) throws TransactionNotInProgressException, ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        if (identity == null) {
            throw new PersistenceException("Identities can't be null!");
        }
        if (this._scope == null) {
            throw new PersistenceException(Messages.message((String)"jdo.dbClosed"));
        }
        TransactionContext tx = this.getTransaction();
        ClassMolder molder = this._scope.getClassMolder(type);
        ProposedEntity proposedObject = new ProposedEntity(molder);
        return tx.load(new Identity(identity), proposedObject, mode);
    }

    public void create(Object object) throws ClassNotPersistenceCapableException, DuplicateIdentityException, TransactionNotInProgressException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        ClassMolder molder = this._scope.getClassMolder(object.getClass());
        tx.create(molder, object, null);
    }

    public CacheManager getCacheManager() {
        if (this.cacheManager == null) {
            this.cacheManager = new CacheManager(this, this._ctx, this.getLockEngine());
        }
        return this.cacheManager;
    }

    public void update(Object object) throws ClassNotPersistenceCapableException, ObjectModifiedException, TransactionNotInProgressException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        ClassMolder molder = this._scope.getClassMolder(object.getClass());
        tx.update(molder, object, null);
    }

    public void remove(Object object) throws ObjectNotPersistentException, LockNotGrantedException, TransactionNotInProgressException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        this._scope.getClassMolder(object.getClass());
        tx.delete(object);
    }

    public boolean isPersistent(Object object) {
        if (this._scope == null) {
            throw new IllegalStateException(Messages.message((String)"jdo.dbClosed"));
        }
        if (this.isActive()) {
            return this._ctx.isPersistent(object);
        }
        return false;
    }

    public Identity getIdentity(Object object) throws PersistenceException {
        if (this._scope == null) {
            throw new PersistenceException(Messages.message((String)"jdo.dbClosed"));
        }
        ClassMolder molder = this._scope.getClassMolder(object.getClass());
        return molder.getActualIdentity(this._classLoader, object);
    }

    public void lock(Object object) throws LockNotGrantedException, ObjectNotPersistentException, TransactionNotInProgressException, PersistenceException {
        if (!this.isActive()) {
            throw new TransactionNotInProgressException(Messages.message((String)"jdo.txNotInProgress"));
        }
        this._ctx.writeLock(object, this._lockTimeout);
    }

    public OQLQuery getOQLQuery() {
        return new OQLQueryImpl(this);
    }

    public OQLQuery getNamedQuery(String name) throws PersistenceException {
        String oql = this._ctx.getNamedQuery(this._scope.findClassMolderByQuery(name), name);
        return this.getOQLQuery(oql);
    }

    public OQLQuery getOQLQuery(String oql) throws PersistenceException {
        OQLQueryImpl oqlImpl = new OQLQueryImpl(this);
        oqlImpl.create(oql);
        return oqlImpl;
    }

    public Query getQuery() {
        return new OQLQueryImpl(this);
    }

    protected TransactionContext getTransaction() throws TransactionNotInProgressException {
        if (this._scope == null) {
            throw new TransactionNotInProgressException(Messages.message((String)"jdo.dbClosed"));
        }
        if (this.isActive()) {
            return this._ctx;
        }
        throw new TransactionNotInProgressException(Messages.message((String)"jdo.dbTxNotInProgress"));
    }

    public abstract void begin() throws PersistenceException;

    public abstract void commit() throws TransactionNotInProgressException, TransactionAbortedException;

    public abstract void rollback() throws TransactionNotInProgressException;

    public boolean isActive() {
        return this._ctx != null && this._ctx.isOpen();
    }

    public String toString() {
        return super.toString() + ":" + this._dbName;
    }

    public abstract Connection getJdbcConnection() throws PersistenceException;

    protected void loadSynchronizables() {
        if (this._synchronizables == null) {
            this._synchronizables = new ArrayList();
            Configuration config = Configuration.getInstance();
            String[] props = config.getProperty("org.exolab.castor.persist.TxSynchronizable");
            for (int i = 0; i < props.length; ++i) {
                try {
                    Class cls = ClassLoadingUtils.loadClass(this._classLoader, props[i]);
                    TxSynchronizable sync = (TxSynchronizable)cls.newInstance();
                    if (sync == null) continue;
                    this._synchronizables.add(sync);
                    continue;
                }
                catch (Exception except) {
                    _log.warn((Object)Messages.format((String)"jdo.missingTxSynchronizable", (Object)props[i]));
                }
            }
            if (this._synchronizables.size() == 0) {
                this._synchronizables = null;
            }
        }
    }

    protected void registerSynchronizables() {
        if (this._synchronizables != null && this._synchronizables.size() > 0) {
            Iterator iter = this._synchronizables.iterator();
            while (iter.hasNext()) {
                this._ctx.addTxSynchronizable((TxSynchronizable)iter.next());
            }
        }
    }

    protected void unregisterSynchronizables() {
        if (this._synchronizables != null && this._synchronizables.size() > 0) {
            Iterator iter = this._synchronizables.iterator();
            while (iter.hasNext()) {
                this._ctx.removeTxSynchronizable((TxSynchronizable)iter.next());
            }
        }
    }

    public TransactionContext getCurrentTransaction() throws TransactionNotInProgressException {
        return this.getTransaction();
    }
}

