/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.sql.Connection;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.persist.GlobalTransactionContext;
import org.castor.util.Messages;
import org.exolab.castor.jdo.DatabaseNotFoundException;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.jdo.TransactionNotInProgressException;
import org.exolab.castor.jdo.engine.AbstractDatabaseImpl;
import org.exolab.castor.jdo.engine.OQLQueryImpl;
import org.exolab.castor.jdo.engine.TxDatabaseMap;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.InstanceFactory;

public class GlobalDatabaseImpl
extends AbstractDatabaseImpl
implements Synchronization {
    private static Log _log = LogFactory.getFactory().getInstance(GlobalDatabaseImpl.class);
    private Transaction _transaction;
    private TxDatabaseMap _txMap;
    boolean _isPoolInUseForGlobalTransactions = false;

    public GlobalDatabaseImpl(String dbName, int lockTimeout, CallbackInterceptor callback, InstanceFactory instanceFactory, Transaction transaction, ClassLoader classLoader, boolean autoStore, boolean isPoolInUseForGlobalTransactions) throws DatabaseNotFoundException {
        super(dbName, lockTimeout, callback, instanceFactory, classLoader, autoStore);
        this._isPoolInUseForGlobalTransactions = isPoolInUseForGlobalTransactions;
        this._transaction = transaction;
        try {
            this._ctx = new GlobalTransactionContext(this);
            this._ctx.setStatus(transaction.getStatus());
        }
        catch (SystemException se) {
            throw new DatabaseNotFoundException(se);
        }
        this._ctx.setLockTimeout(this._lockTimeout);
        this._ctx.setAutoStore(this._autoStore);
        this._ctx.setCallback(this._callback);
        this._ctx.setInstanceFactory(this._instanceFactory);
        this._classLoader = classLoader;
        this.loadSynchronizables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws PersistenceException {
        try {
            try {
                this._ctx.close();
            }
            catch (Exception e) {
                throw new PersistenceException(e.getMessage(), e);
            }
        }
        finally {
            this._scope = null;
        }
    }

    protected void finalize() throws Throwable {
        if (this._scope != null || !this.isActive()) {
            return;
        }
        if (!this._isPoolInUseForGlobalTransactions) {
            OQLQuery oqlQuery = this.getOQLQuery();
            String sql = ((OQLQueryImpl)oqlQuery).getSQL();
            _log.warn((Object)Messages.format((String)"jdo.finalize_close", (Object)this.toString(), (Object)this._dbName, (Object)sql));
        }
        this.close();
    }

    public void begin() throws PersistenceException {
        throw new IllegalStateException(Messages.message((String)"jdo.txInJ2EE"));
    }

    public void commit() throws TransactionNotInProgressException, TransactionAbortedException {
        throw new IllegalStateException(Messages.message((String)"jdo.txInJ2EE"));
    }

    public void rollback() throws TransactionNotInProgressException {
        throw new IllegalStateException(Messages.message((String)"jdo.txInJ2EE"));
    }

    public void beforeCompletion() {
        if (this._transaction == null || this._ctx == null || !this._ctx.isOpen()) {
            throw new IllegalStateException(Messages.message((String)"jdo.txNotInProgress"));
        }
        if (this._ctx.getStatus() == 1) {
            try {
                this._transaction.setRollbackOnly();
            }
            catch (SystemException except) {
                _log.warn((Object)Messages.format((String)"jdo.warnException", (Object)((Object)except)));
            }
            return;
        }
        try {
            this._ctx.prepare();
        }
        catch (TransactionAbortedException tae) {
            _log.error((Object)Messages.format((String)"jdo.txAbortedMarkRollback", (Object)tae.getMessage()), (Throwable)((Object)tae));
            try {
                this._transaction.setRollbackOnly();
            }
            catch (SystemException se) {
                _log.fatal((Object)Messages.format((String)"jdo.txMarkRollbackFailure", (Object)se.getMessage()), (Throwable)se);
            }
            this._ctx.rollback();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void afterCompletion(int status) {
        block13: {
            block12: {
                block11: {
                    try {
                        if (this._transaction == null) throw new IllegalStateException(Messages.message((String)"jdo.txNotInProgress"));
                        if (this._ctx == null) {
                            throw new IllegalStateException(Messages.message((String)"jdo.txNotInProgress"));
                        }
                        if (this._ctx.getStatus() == 4) {
                            Object var4_2 = null;
                            if (this._txMap == null) return;
                            if (this._transaction == null) return;
                            this._txMap.remove(this._transaction);
                            break block11;
                        }
                        if (this._ctx.getStatus() != 2 && status != 4) {
                            throw new IllegalStateException("Unexpected state: afterCompletion called at status " + this._ctx.getStatus());
                        }
                        switch (status) {
                            case 3: {
                                try {
                                    this._ctx.commit();
                                }
                                catch (TransactionAbortedException except) {
                                    _log.fatal((Object)Messages.format((String)"jdo.fatalException", (Object)((Object)except)));
                                    this._ctx.rollback();
                                }
                                break block12;
                            }
                            case 4: {
                                this._ctx.rollback();
                                break block13;
                            }
                            default: {
                                this._ctx.rollback();
                                throw new IllegalStateException("Unexpected state: afterCompletion called with status " + status);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        if (this._txMap == null) throw throwable;
                        if (this._transaction == null) throw throwable;
                        this._txMap.remove(this._transaction);
                        this._txMap = null;
                        throw throwable;
                    }
                }
                this._txMap = null;
                return;
            }
            Object var4_3 = null;
            if (this._txMap == null) return;
            if (this._transaction == null) return;
            this._txMap.remove(this._transaction);
            this._txMap = null;
            return;
        }
        Object var4_4 = null;
        if (this._txMap == null) return;
        if (this._transaction == null) return;
        this._txMap.remove(this._transaction);
        this._txMap = null;
    }

    void setTxMap(TxDatabaseMap txMap) {
        this._txMap = txMap;
    }

    public Connection getJdbcConnection() throws PersistenceException {
        return this._ctx.getConnection(this._scope.getLockEngine());
    }
}

