/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.persist.TransactionContext;
import org.castor.persist.cache.CacheEntry;
import org.castor.util.Messages;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.persist.DepositBox;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectDeletedWaitingForLockException;

public final class ObjectLock
implements DepositBox {
    private static Log log = LogFactory.getFactory().getInstance(ObjectLock.class);
    static final short ACTION_READ = 1;
    static final short ACTION_WRITE = 2;
    static final short ACTION_CREATE = 3;
    static final short ACTION_UPDATE = 4;
    static int idcount = 0;
    static final int[] lock = new int[0];
    private int _id;
    private Object[] _object;
    private OID _oid;
    private TransactionContext _writeLock;
    private LinkedTx _readLock;
    private LinkedTx _readWaiting;
    private int _waitCount;
    private LinkedTx _writeWaiting;
    private TransactionContext _confirmWaiting;
    private short _confirmWaitingAction;
    private int _gateCount;
    private long _timeStamp;
    private boolean _deleted;
    private boolean _invalidated;
    private boolean _isExpired;
    private Object[] _expiredObject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectLock(OID oid) {
        this._oid = oid;
        int[] nArray = lock;
        synchronized (lock) {
            this._id = idcount++;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public ObjectLock(CacheEntry entry) {
        this(entry.getOID());
        this._isExpired = false;
        this._expiredObject = null;
        this._object = entry.getEntry();
        this._timeStamp = entry.getTimeStamp();
    }

    public OID getOID() {
        return this._oid;
    }

    void setOID(OID oid) {
        this._oid = oid;
    }

    void enter() {
        ++this._gateCount;
    }

    void leave() {
        --this._gateCount;
    }

    boolean isEntered() {
        return this._gateCount != 0;
    }

    boolean isDisposable() {
        return this._gateCount == 0 && this.isFree() && this._waitCount == 0;
    }

    boolean hasLock(TransactionContext tx, boolean write) {
        if (this._writeLock == tx) {
            return true;
        }
        if (this._confirmWaiting == tx) {
            if (this._confirmWaitingAction == 2 || this._confirmWaitingAction == 3) {
                return true;
            }
            return !write && this._confirmWaitingAction == 1;
        }
        if (write) {
            return false;
        }
        LinkedTx read = this._readLock;
        while (read != null) {
            if (read.tx == tx) {
                return true;
            }
            read = read.next;
        }
        return false;
    }

    boolean isFree() {
        return this._writeLock == null && this._readLock == null && this._writeWaiting == null && this._readWaiting == null && this._confirmWaiting == null && this._waitCount == 0;
    }

    boolean isExclusivelyOwned(TransactionContext tx) {
        if (this._writeLock == null && this._readLock == null) {
            return false;
        }
        if (this._writeLock == null && this._readLock.tx == tx && this._readLock.next.tx == null) {
            return true;
        }
        return this._writeLock == tx && this._readLock == null;
    }

    boolean isExpired() {
        return this._isExpired;
    }

    public Object[] getObject() {
        if (this._expiredObject != null && this._object == null) {
            return this._expiredObject;
        }
        return this._object;
    }

    public void expire() {
        this._isExpired = true;
    }

    public void expired() {
        this._isExpired = false;
        this._expiredObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void acquireLoadLock(TransactionContext tx, boolean write, int timeout) throws LockNotGrantedException, ObjectDeletedWaitingForLockException {
        long endtime = timeout > 0 ? System.currentTimeMillis() + (long)(timeout * 1000) : Long.MAX_VALUE;
        while (true) {
            try {
                if (this._deleted) {
                    throw new ObjectDeletedWaitingForLockException("Object deleted");
                }
                if (this._confirmWaiting != null) {
                    try {
                        ++this._waitCount;
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new LockNotGrantedException("Thread interrupted acquiring lock!", e);
                    }
                    finally {
                        --this._waitCount;
                        continue;
                    }
                }
                if (this._writeLock == tx) {
                    return;
                }
                if (this._readLock == null && this._writeLock == null && write) {
                    this._confirmWaiting = tx;
                    this._confirmWaitingAction = (short)2;
                    return;
                }
                if (this._readLock == null && this._writeLock == null && !write) {
                    if (this._object == null) {
                        this._confirmWaiting = tx;
                        this._confirmWaitingAction = 1;
                        return;
                    }
                    this._readLock = new LinkedTx(tx, null);
                    return;
                }
                if (this._readLock != null && !write) {
                    LinkedTx linked = this._readLock;
                    while (linked != null) {
                        if (linked.tx == tx) {
                            throw new IllegalStateException("Transaction: " + tx + " has already hold the write lock on " + this._oid + " Acquire shouldn't be called twice");
                        }
                        linked = linked.next;
                    }
                    this._readLock = new LinkedTx(tx, this._readLock);
                    return;
                }
                if (timeout == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Timeout on " + this.toString() + " by " + tx));
                    }
                    throw new LockNotGrantedException((write ? "persist.writeLockTimeout" : "persist.readLockTimeout") + this._oid + "/" + this._id + " by " + tx);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Waiting on " + this.toString() + " by " + tx));
                }
                tx.setWaitOnLock(this);
                this.detectDeadlock(tx, 10);
                if (write) {
                    this._writeWaiting = new LinkedTx(tx, this._writeWaiting);
                } else {
                    this._readWaiting = new LinkedTx(tx, this._readWaiting);
                }
                try {
                    long waittime = endtime - System.currentTimeMillis();
                    this.wait(waittime < 0L ? 0L : waittime);
                }
                catch (InterruptedException except) {
                    throw new LockNotGrantedException(write ? "persist.writeLockTimeout" : "persist.readLockTimeout" + this._oid + "/" + this._id + " by " + tx, except);
                }
                if (this._deleted) {
                    throw new ObjectDeletedWaitingForLockException("object deleted" + this._oid + "/" + this._id + " by " + tx);
                }
                if (System.currentTimeMillis() > endtime) {
                    timeout = 0;
                }
                this.removeWaiting(tx);
                tx.setWaitOnLock(null);
                continue;
            }
            finally {
                this.removeWaiting(tx);
                tx.setWaitOnLock(null);
                continue;
            }
            break;
        }
    }

    synchronized void acquireCreateLock(TransactionContext tx) throws LockNotGrantedException {
        while (this._deleted || this._confirmWaiting != null) {
            try {
                ++this._waitCount;
                this.wait();
                while (this._deleted) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new LockNotGrantedException("Thread interrupted acquiring lock!", e);
            }
            finally {
                --this._waitCount;
            }
        }
        if (this._readLock != null || this._writeLock != null) {
            throw new LockNotGrantedException("Lock already exist!");
        }
        this._confirmWaiting = tx;
        this._confirmWaitingAction = (short)3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void acquireUpdateLock(TransactionContext tx, int timeout) throws LockNotGrantedException, ObjectDeletedWaitingForLockException {
        long endtime = timeout > 0 ? System.currentTimeMillis() + (long)(timeout * 1000) : Long.MAX_VALUE;
        while (true) {
            try {
                if (this._deleted || this._confirmWaiting != null) {
                    try {
                        ++this._waitCount;
                        this.wait();
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new LockNotGrantedException("Thread interrupted acquiring lock!", e);
                    }
                    finally {
                        --this._waitCount;
                        continue;
                    }
                }
                if (this._writeLock == tx) {
                    return;
                }
                if (this._writeLock == null && this._readLock == null) {
                    this._confirmWaiting = tx;
                    this._confirmWaitingAction = (short)4;
                    return;
                }
                if (timeout == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Timeout on " + this.toString() + " by " + tx));
                    }
                    throw new LockNotGrantedException(Messages.message((String)"persist.writeLockTimeout"));
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Waiting on " + this.toString() + " by " + tx));
                }
                tx.setWaitOnLock(this);
                this.detectDeadlock(tx, 10);
                this._writeWaiting = new LinkedTx(tx, this._writeWaiting);
                try {
                    long waittime = endtime - System.currentTimeMillis();
                    this.wait(waittime < 0L ? 0L : waittime);
                }
                catch (InterruptedException except) {
                    throw new LockNotGrantedException(Messages.message((String)"persist.writeLockTimeout") + this._oid + "/" + this._id + " by " + tx, except);
                }
                if (this._deleted) {
                    throw new ObjectDeletedWaitingForLockException("Object deleted " + this._oid + "/" + this._id + " by " + tx);
                }
                if (System.currentTimeMillis() > endtime) {
                    timeout = 0;
                }
                this.removeWaiting(tx);
                tx.setWaitOnLock(null);
                continue;
            }
            finally {
                this.removeWaiting(tx);
                tx.setWaitOnLock(null);
                continue;
            }
            break;
        }
    }

    public synchronized void setObject(TransactionContext tx, Object[] object) {
        this._isExpired = false;
        this._expiredObject = null;
        if (this._confirmWaiting != null && this._confirmWaiting == tx) {
            this._timeStamp = System.currentTimeMillis();
            this._object = object;
            if (this._confirmWaitingAction == 1) {
                this._readLock = new LinkedTx(tx, null);
            } else {
                this._writeLock = tx;
            }
            this._confirmWaiting = null;
            this.notifyAll();
        } else if (this._writeLock != null && this._writeLock == tx) {
            this._timeStamp = System.currentTimeMillis();
            this._object = object;
        } else {
            throw new IllegalArgumentException("Transaction tx does not own this lock, " + this.toString() + "!");
        }
    }

    public synchronized Object[] getObject(TransactionContext tx) {
        if (this._confirmWaiting != null && this._confirmWaiting == tx) {
            return this._object;
        }
        if (this._writeLock != null && this._writeLock == tx) {
            return this._object;
        }
        LinkedTx link = this._readLock;
        while (link != null) {
            if (link.tx == tx) {
                return this._object;
            }
            link = link.next;
        }
        throw new IllegalArgumentException("Transaction tx does not own this lock!");
    }

    public synchronized long getTimeStamp() {
        return this._timeStamp;
    }

    synchronized void confirm(TransactionContext tx, boolean succeed) {
        if (this._confirmWaiting == tx) {
            if (succeed) {
                if (this._confirmWaitingAction == 1) {
                    if (this._readLock == null) {
                        this._readLock = new LinkedTx(tx, null);
                    }
                } else {
                    this._writeLock = tx;
                }
            }
            this._confirmWaiting = null;
            this.notifyAll();
        } else if (this._confirmWaiting == null) {
            if (!succeed) {
                if (this._writeLock != null) {
                    this._deleted = true;
                    this._object = null;
                    this._timeStamp = System.currentTimeMillis();
                    this.notifyAll();
                } else if (this._readLock != null) {
                    if (this._readLock.tx == tx) {
                        this._readLock = this._readLock.next;
                    } else {
                        LinkedTx link = this._readLock;
                        while (link != null) {
                            if (link.next != null && link.next.tx == tx) {
                                link.next = link.next.next;
                                this.notifyAll();
                                return;
                            }
                            link = link.next;
                        }
                    }
                }
            }
            this.notifyAll();
        } else {
            throw new IllegalStateException("Confirm transaction does not match the locked transaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void upgrade(TransactionContext tx, int timeout) throws LockNotGrantedException, ObjectDeletedWaitingForLockException {
        if (this._confirmWaiting != null) {
            IllegalStateException e = new IllegalStateException("Internal error: acquire when confirmWaiting is not null");
            throw e;
        }
        if (!this.hasLock(tx, false)) {
            IllegalStateException e = new IllegalStateException("Transaction didn't previously acquire this lock");
            throw e;
        }
        long endtime = timeout > 0 ? System.currentTimeMillis() + (long)(timeout * 1000) : Long.MAX_VALUE;
        while (true) {
            try {
                if (this._writeLock == tx) {
                    return;
                }
                if (this._writeLock == null && this._readLock.tx == tx && this._readLock.next == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Acquired on " + this.toString() + " by " + tx));
                    }
                    this._writeLock = tx;
                    this._readLock = null;
                    return;
                }
                if (timeout == 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Timeout on " + this.toString() + " by " + tx));
                    }
                    throw new LockNotGrantedException("persist.writeTimeout" + this._oid + "/" + this._id + " by " + tx);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Waiting on " + this.toString() + " by " + tx));
                }
                tx.setWaitOnLock(this);
                this.detectDeadlock(tx, 10);
                this._writeWaiting = new LinkedTx(tx, this._writeWaiting);
                try {
                    long waittime = endtime - System.currentTimeMillis();
                    this.wait(waittime < 0L ? 0L : waittime);
                }
                catch (InterruptedException except) {
                    throw new LockNotGrantedException("persist.writeLockTimeout", except);
                }
                if (this._deleted) {
                    throw new IllegalStateException("internal error: object deleted" + this._oid + "/" + this._id + " by " + tx);
                }
                if (System.currentTimeMillis() > endtime) {
                    timeout = 0;
                }
                this.removeWaiting(tx);
                tx.setWaitOnLock(null);
                continue;
            }
            finally {
                this.removeWaiting(tx);
                tx.setWaitOnLock(null);
                continue;
            }
            break;
        }
    }

    synchronized void release(TransactionContext tx) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Release " + this.toString() + " by " + tx));
        }
        try {
            tx.setWaitOnLock(null);
            if (this._writeLock == tx) {
                this._writeLock = null;
                if (this._invalidated || this._deleted) {
                    this._timeStamp = System.currentTimeMillis();
                    if (this._isExpired) {
                        this._expiredObject = this._object;
                    }
                    this._object = null;
                }
                this._deleted = false;
                this._invalidated = false;
            } else if (this._readLock != null) {
                if (this._readLock.tx == tx) {
                    this._readLock = this._readLock.next;
                } else {
                    LinkedTx read = this._readLock;
                    while (read != null) {
                        if (read.next != null && read.next.tx == tx) {
                            read.next = read.next.next;
                            break;
                        }
                        read = read.next;
                    }
                    if (read == null) {
                        throw new IllegalStateException(Messages.message((String)"persist.notOwnerLock") + this._oid + "/" + this._id + " by " + tx);
                    }
                }
            } else {
                throw new IllegalStateException(Messages.message((String)"persist.notOwnerLock") + this._oid + "/" + this._id + " by " + tx);
            }
            this.notifyAll();
        }
        catch (ThreadDeath death) {
            this.release(tx);
            throw death;
        }
    }

    synchronized void delete(TransactionContext tx) {
        if (tx != this._writeLock) {
            throw new IllegalStateException(Messages.message((String)"persist.notOwnerLock") + " oid:" + this._oid + "/" + this._id + " by " + tx);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Delete " + this.toString() + " by " + tx));
        }
        try {
            this._deleted = true;
            this._object = null;
            this.notifyAll();
        }
        catch (ThreadDeath death) {
            this.release(tx);
            throw death;
        }
    }

    synchronized void invalidate(TransactionContext tx) {
        if (tx != this._writeLock) {
            throw new IllegalStateException(Messages.message((String)"persist.notOwnerLock") + " oid:" + this._oid + "/" + this._id + " by " + tx);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Delete " + this.toString() + " by " + tx));
        }
        this._invalidated = true;
    }

    private void detectDeadlock(TransactionContext waitingTx, int numOfRec) throws LockNotGrantedException {
        if (numOfRec <= 0) {
            return;
        }
        if (this._writeLock != null) {
            ObjectLock waitOn = this._writeLock.getWaitOnLock();
            if (waitOn != null) {
                if (waitOn._writeLock == waitingTx) {
                    throw new LockNotGrantedException(Messages.message((String)"persist.deadlock"));
                }
                LinkedTx read = waitOn._readLock;
                while (read != null) {
                    if (read.tx == waitingTx) {
                        throw new LockNotGrantedException(Messages.message((String)"persist.deadlock"));
                    }
                    read = read.next;
                }
                waitOn.detectDeadlock(waitingTx, numOfRec - 1);
            }
        } else {
            LinkedTx lock = this._readLock;
            while (lock != null) {
                ObjectLock waitOn = lock.tx.getWaitOnLock();
                if (waitOn != null && lock.tx != waitingTx) {
                    if (waitOn._writeLock == waitingTx) {
                        throw new LockNotGrantedException(Messages.message((String)"persist.deadlock"));
                    }
                    LinkedTx read = waitOn._readLock;
                    while (read != null) {
                        if (read.tx == waitingTx) {
                            throw new LockNotGrantedException(Messages.message((String)"persist.deadlock"));
                        }
                        read = read.next;
                    }
                    waitOn.detectDeadlock(waitingTx, numOfRec - 1);
                }
                lock = lock.next;
            }
        }
    }

    private void removeWaiting(TransactionContext tx) {
        try {
            LinkedTx wait;
            if (this._writeWaiting != null) {
                if (this._writeWaiting.tx == tx) {
                    this._writeWaiting = this._writeWaiting.next;
                } else {
                    wait = this._writeWaiting;
                    while (wait.next != null) {
                        if (wait.next.tx == tx) {
                            wait.next = wait.next.next;
                            break;
                        }
                        wait = wait.next;
                    }
                }
            }
            if (this._readWaiting != null) {
                if (this._readWaiting.tx == tx) {
                    this._readWaiting = this._readWaiting.next;
                } else {
                    wait = this._readWaiting;
                    while (wait.next != null) {
                        if (wait.next.tx == tx) {
                            wait.next = wait.next.next;
                            break;
                        }
                        wait = wait.next;
                    }
                }
            }
            if (this._deleted && this._readWaiting == null && this._writeWaiting == null && this._confirmWaiting == null) {
                this._deleted = false;
            }
        }
        catch (ThreadDeath death) {
            this.removeWaiting(tx);
            throw death;
        }
    }

    public String toString() {
        return this._oid.toString() + "/" + this._id + " " + (this._readLock == null ? "-" : "R") + "/" + (this._writeLock == null ? "-" : "W");
    }

    static class LinkedTx {
        TransactionContext tx;
        LinkedTx next;

        LinkedTx(TransactionContext tx, LinkedTx next) {
            this.tx = tx;
            this.next = next;
        }
    }
}

