/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.util.Configuration;
import org.castor.util.Messages;
import org.exolab.castor.persist.spi.PersistenceFactory;

public class PersistenceFactoryRegistry {
    private static final Log LOG = LogFactory.getLog((Class)PersistenceFactoryRegistry.class);
    private static Hashtable _factories;

    public static PersistenceFactory getPersistenceFactory(String name) {
        PersistenceFactoryRegistry.load();
        return (PersistenceFactory)_factories.get(name);
    }

    public static String[] getFactoryNames() {
        PersistenceFactoryRegistry.load();
        String[] names = new String[_factories.size()];
        Enumeration enumeration = _factories.keys();
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)enumeration.nextElement();
        }
        return names;
    }

    private static synchronized void load() {
        if (_factories == null) {
            _factories = new Hashtable();
            Configuration config = Configuration.getInstance();
            String[] props = config.getProperty("org.exolab.castor.jdo.engines");
            ClassLoader ldr = PersistenceFactoryRegistry.class.getClassLoader();
            for (int i = 0; i < props.length; ++i) {
                try {
                    Object factory = ldr.loadClass(props[i]).newInstance();
                    _factories.put(((PersistenceFactory)factory).getFactoryName(), factory);
                    continue;
                }
                catch (Exception except) {
                    LOG.error((Object)Messages.format((String)"persist.missingPersistenceFactory", (Object)props[i]));
                }
            }
        }
    }
}

